/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.element.SoundDetectionElement;
import fuzs.betteranimationscollection.client.model.SpitfulLlamaModel;
import fuzs.betteranimationscollection.mixin.client.accessor.LlamaDecorLayerAccessor;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import java.util.Optional;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.layers.LlamaDecorLayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.animal.horse.Llama;

public class SpitfulLlamaElement
extends SoundDetectionElement {
    private final ModelLayerLocation animatedLlama;
    private final ModelLayerLocation animatedLlamaDecor;

    public SpitfulLlamaElement(ModelLayerRegistry modelLayerRegistry) {
        super(Llama.class, SoundEvents.f_12098_);
        this.animatedLlama = modelLayerRegistry.register("animated_llama");
        this.animatedLlamaDecor = modelLayerRegistry.register("animated_llama", "decor");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"This one makes llamas open their mouth when spitting. How have they been doing that before?!"};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(LlamaModel.class, () -> new SpitfulLlamaModel(bakery.bakeLayer(this.animatedLlama)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof LlamaDecorLayer) {
                ((LlamaDecorLayerAccessor)renderLayer).setModel(new SpitfulLlamaModel<Llama>(bakery.bakeLayer(this.animatedLlamaDecor)));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedLlama, () -> SpitfulLlamaModel.createAnimatedBodyLayer(CubeDeformation.f_171458_));
        context.registerLayerDefinition(this.animatedLlamaDecor, () -> SpitfulLlamaModel.createAnimatedBodyLayer(new CubeDeformation(0.5f)));
    }
}

