/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;

public abstract class ModelElementBase {
    private boolean enabled = true;
    private boolean dirty = true;

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public abstract String[] modelDescription();

    public final void registerAnimatedModels(AnimatedModelsContext context, EntityModelBakery bakery) {
        this.dirty = false;
        if (this.enabled) {
            this.onRegisterAnimatedModels(context, bakery);
        }
    }

    abstract void onRegisterAnimatedModels(AnimatedModelsContext var1, EntityModelBakery var2);

    public abstract void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext var1);

    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
    }

    @FunctionalInterface
    public static interface AnimatedModelsContext {
        default public <T extends LivingEntity, M extends EntityModel<T>> void registerAnimatedModel(Class<? super M> vanillaModelClazz, Supplier<? extends M> animatedModel) {
            this.registerAnimatedModel(vanillaModelClazz, animatedModel, (renderLayerParent, renderLayer) -> Optional.empty());
        }

        public <T extends LivingEntity, M extends EntityModel<T>> void registerAnimatedModel(Class<? super M> var1, Supplier<? extends M> var2, LayerTransformer<T, M> var3);
    }

    public record EntityModelBakery(Supplier<EntityModelSet> entityModelSet) {
        public EntityModelSet get() {
            return this.entityModelSet.get();
        }

        public ModelPart bakeLayer(ModelLayerLocation modelLayerLocation) {
            return this.entityModelSet.get().m_171103_(modelLayerLocation);
        }

        public static EntityModelBakery of(Supplier<EntityModelSet> entityModelSet) {
            return new EntityModelBakery(entityModelSet);
        }
    }

    public record AnimatedModelData<T extends LivingEntity, M extends EntityModel<T>>(Class<? super M> vanillaModelClazz, Supplier<? extends M> animatedModel, LayerTransformer<T, M> layerTransformer) {
    }

    @FunctionalInterface
    public static interface LayerTransformer<T extends LivingEntity, M extends EntityModel<T>> {
        public Optional<RenderLayer<T, M>> apply(RenderLayerParent<T, M> var1, RenderLayer<T, M> var2);
    }
}

