/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.DrownedKneesModel;
import fuzs.betteranimationscollection.client.model.HumanoidKneesModel;
import fuzs.betteranimationscollection.client.model.PiglinKneesModel;
import fuzs.betteranimationscollection.client.model.ZombieKneesModel;
import fuzs.betteranimationscollection.mixin.client.accessor.DrownedOuterLayerAccessor;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import java.util.Optional;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;

public class HumanoidKneesElement
extends ModelElementBase {
    private final ModelLayerLocation animatedZombie;
    private final ModelLayerLocation animatedZombieInnerArmor;
    private final ModelLayerLocation animatedZombieOuterArmor;
    private final ModelLayerLocation animatedDrowned;
    private final ModelLayerLocation animatedDrownedOuterLayer;
    private final ModelLayerLocation animatedDrownedInnerArmor;
    private final ModelLayerLocation animatedDrownedOuterArmor;
    private final ModelLayerLocation animatedPiglin;
    private final ModelLayerLocation animatedPiglinInnerArmor;
    private final ModelLayerLocation animatedPiglinOuterArmor;

    public HumanoidKneesElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedZombie = modelLayerRegistry.register("animated_zombie");
        this.animatedZombieInnerArmor = modelLayerRegistry.registerInnerArmor("animated_zombie");
        this.animatedZombieOuterArmor = modelLayerRegistry.registerOuterArmor("animated_zombie");
        this.animatedDrowned = modelLayerRegistry.register("animated_drowned");
        this.animatedDrownedOuterLayer = modelLayerRegistry.register("animated_drowned", "outer");
        this.animatedDrownedInnerArmor = modelLayerRegistry.registerInnerArmor("animated_drowned");
        this.animatedDrownedOuterArmor = modelLayerRegistry.registerOuterArmor("animated_drowned");
        this.animatedPiglin = modelLayerRegistry.register("animated_piglin");
        this.animatedPiglinInnerArmor = modelLayerRegistry.registerInnerArmor("animated_piglin");
        this.animatedPiglinOuterArmor = modelLayerRegistry.registerOuterArmor("animated_piglin");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"This one makes the knees of zombie-like and piglin-like mobs bend when they walk around.", "Looks pretty fluid and nice. You'll like it, trust me."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(ZombieModel.class, () -> new ZombieKneesModel(bakery.bakeLayer(this.animatedZombie)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof HumanoidArmorLayer) {
                return Optional.of(new HumanoidArmorLayer(renderLayerParent, new ZombieKneesModel(bakery.bakeLayer(this.animatedZombieInnerArmor)), new ZombieKneesModel(bakery.bakeLayer(this.animatedZombieOuterArmor))));
            }
            return Optional.empty();
        });
        context.registerAnimatedModel(DrownedModel.class, () -> new DrownedKneesModel(bakery.bakeLayer(this.animatedDrowned)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof HumanoidArmorLayer) {
                return Optional.of(new HumanoidArmorLayer(renderLayerParent, new DrownedKneesModel(bakery.bakeLayer(this.animatedDrownedInnerArmor)), new DrownedKneesModel(bakery.bakeLayer(this.animatedDrownedOuterArmor))));
            }
            if (renderLayer instanceof DrownedOuterLayer) {
                ((DrownedOuterLayerAccessor)renderLayer).setModel(new DrownedKneesModel(bakery.bakeLayer(this.animatedDrownedOuterLayer)));
            }
            return Optional.empty();
        });
        context.registerAnimatedModel(PiglinModel.class, () -> new PiglinKneesModel(bakery.bakeLayer(this.animatedPiglin)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof HumanoidArmorLayer) {
                return Optional.of(new HumanoidArmorLayer(renderLayerParent, new HumanoidKneesModel(bakery.bakeLayer(this.animatedPiglinInnerArmor)), new HumanoidKneesModel(bakery.bakeLayer(this.animatedPiglinOuterArmor))));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedZombie, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(CubeDeformation.f_171458_, 0.0f), (int)64, (int)64));
        context.registerLayerDefinition(this.animatedZombieInnerArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(0.5f), 0.0f), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedZombieOuterArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(1.0f), 0.0f), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedDrowned, () -> LayerDefinition.m_171565_((MeshDefinition)DrownedKneesModel.createAnimatedMesh(CubeDeformation.f_171458_, 0.0f), (int)64, (int)64));
        context.registerLayerDefinition(this.animatedDrownedOuterLayer, () -> LayerDefinition.m_171565_((MeshDefinition)DrownedKneesModel.createAnimatedMesh(new CubeDeformation(0.25f), 0.0f), (int)64, (int)64));
        context.registerLayerDefinition(this.animatedDrownedInnerArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(0.5f), 0.0f), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedDrownedOuterArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(1.0f), 0.0f), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedPiglin, PiglinKneesModel::createAnimatedBodyLayer);
        context.registerLayerDefinition(this.animatedPiglinInnerArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(0.5f), 0.0f), (int)64, (int)32));
        context.registerLayerDefinition(this.animatedPiglinOuterArmor, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidKneesModel.createAnimatedMesh(new CubeDeformation(1.02f), 0.0f), (int)64, (int)32));
    }
}

