/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.GhastTentaclesModel;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.geom.ModelLayerLocation;

public class GhastTentaclesElement
extends ModelElementBase {
    public static int maxTentaclesLength;
    public static int animationSpeed;
    private final ModelLayerLocation animatedGhast;

    public GhastTentaclesElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedGhast = modelLayerRegistry.register("animated_ghast");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Divides ghast tentacles into parts and makes them wiggle realistically, like those tentacle monsters you always see at the movies.", "Makes them a little more scary, but ultimately nicer to look at."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(GhastModel.class, () -> new GhastTentaclesModel(bakery.bakeLayer(this.animatedGhast)));
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedGhast, GhastTentaclesModel::createAnimatedBodyLayer);
    }

    @Override
    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Define the max length of tentacles.").defineInRange("max_tentacles_length", 14, 2, 14), v -> {
            maxTentaclesLength = v;
        });
        callback.accept((Supplier)builder.comment("Animation swing speed of tentacles.").defineInRange("animation_speed", 5, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

