/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.FlailingEndermanModel;
import fuzs.betteranimationscollection.client.renderer.entity.layers.FlailingCarriedBlockLayer;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CarriedBlockLayer;
import net.minecraft.world.entity.monster.EnderMan;

public class FlailingEndermanElement
extends ModelElementBase {
    public static int animationSpeed;
    public static boolean whileCarrying;
    private final ModelLayerLocation animatedEnderman;

    public FlailingEndermanElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedEnderman = modelLayerRegistry.register("animated_enderman");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"If an enderman is angry it will wave its arms around wildly while chasing its target.", "Suits their twisted nature very well."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(EndermanModel.class, () -> new FlailingEndermanModel(bakery.bakeLayer(this.animatedEnderman)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof CarriedBlockLayer) {
                return Optional.of(new FlailingCarriedBlockLayer((RenderLayerParent<EnderMan, EndermanModel<EnderMan>>)renderLayerParent, Minecraft.m_91087_().m_91289_()));
            }
            return Optional.empty();
        });
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedEnderman, FlailingEndermanModel::createAnimatedBodyLayer);
    }

    @Override
    public void setupModelConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Animation swing speed for arms.").defineInRange("animation_speed", 5, 1, 20), v -> {
            animationSpeed = v;
        });
        callback.accept((Supplier)builder.comment("Flail arms while carrying a block.").define("fail_while_carrying", true), v -> {
            whileCarrying = v;
        });
    }
}

