/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.model.FamiliarChestedHorseModel;
import fuzs.betteranimationscollection.client.model.FamiliarHorseModel;
import fuzs.betteranimationscollection.mixin.client.accessor.HorseArmorLayerAccessor;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import java.util.Optional;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.world.entity.animal.horse.Horse;

public class FamiliarHorseElement
extends ModelElementBase {
    private final ModelLayerLocation animatedHorse;
    private final ModelLayerLocation animatedHorseArmor;
    private final ModelLayerLocation animatedChestedHorse;

    public FamiliarHorseElement(ModelLayerRegistry modelLayerRegistry) {
        this.animatedHorse = modelLayerRegistry.register("animated_horse");
        this.animatedHorseArmor = modelLayerRegistry.register("animated_horse_armor");
        this.animatedChestedHorse = modelLayerRegistry.register("animated_chested_horse");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Makes horses more lively again, just like they used to be in older versions.", "Does this by adding back their mouth and knees while staying true to the vanilla model style."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElementBase.AnimatedModelsContext context, ModelElementBase.EntityModelBakery bakery) {
        context.registerAnimatedModel(HorseModel.class, () -> new FamiliarHorseModel(bakery.bakeLayer(this.animatedHorse)), (renderLayerParent, renderLayer) -> {
            if (renderLayer instanceof HorseArmorLayer) {
                ((HorseArmorLayerAccessor)renderLayer).setModel(new FamiliarHorseModel<Horse>(bakery.bakeLayer(this.animatedHorseArmor)));
            }
            return Optional.empty();
        });
        context.registerAnimatedModel(ChestedHorseModel.class, () -> new FamiliarChestedHorseModel(bakery.bakeLayer(this.animatedChestedHorse)));
    }

    @Override
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(this.animatedHorse, () -> LayerDefinition.m_171565_((MeshDefinition)FamiliarHorseModel.createAnimatedBodyMesh(CubeDeformation.f_171458_), (int)64, (int)64));
        context.registerLayerDefinition(this.animatedHorseArmor, () -> LayerDefinition.m_171565_((MeshDefinition)FamiliarHorseModel.createAnimatedBodyMesh(new CubeDeformation(0.1f)), (int)64, (int)64));
        context.registerLayerDefinition(this.animatedChestedHorse, FamiliarChestedHorseModel::createAnimatedBodyLayer);
    }
}

