/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client;

import com.google.common.collect.Maps;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.client.element.BuckaChickenElement;
import fuzs.betteranimationscollection.client.element.CatTailElement;
import fuzs.betteranimationscollection.client.element.CowUdderElement;
import fuzs.betteranimationscollection.client.element.FamiliarHorseElement;
import fuzs.betteranimationscollection.client.element.FlailingEndermanElement;
import fuzs.betteranimationscollection.client.element.GhastTentaclesElement;
import fuzs.betteranimationscollection.client.element.HumanoidKneesElement;
import fuzs.betteranimationscollection.client.element.IronGolemNoseElement;
import fuzs.betteranimationscollection.client.element.JigglySlimeElement;
import fuzs.betteranimationscollection.client.element.KneelingSheepElement;
import fuzs.betteranimationscollection.client.element.MagmaCubeBurgerElement;
import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.betteranimationscollection.client.element.OcelotTailElement;
import fuzs.betteranimationscollection.client.element.OinkyPigElement;
import fuzs.betteranimationscollection.client.element.PlayfulDoggyElement;
import fuzs.betteranimationscollection.client.element.SnowGolemStickElement;
import fuzs.betteranimationscollection.client.element.SpiderKneesElement;
import fuzs.betteranimationscollection.client.element.SpitfulLlamaElement;
import fuzs.betteranimationscollection.client.element.SquidTentaclesElement;
import fuzs.betteranimationscollection.client.element.VillagerNoseElement;
import fuzs.betteranimationscollection.client.element.WobblyCreeperElement;
import fuzs.betteranimationscollection.config.ClientConfig;
import fuzs.betteranimationscollection.mixin.client.accessor.EntityRenderDispatcherAccessor;
import fuzs.betteranimationscollection.mixin.client.accessor.LivingEntityRendererAccessor;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.model.geom.ModelLayerRegistry;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class BetterAnimationsCollectionClient
implements ClientModConstructor {
    private static final ModelLayerRegistry MODEL_LAYER_REGISTRY = ModelLayerRegistry.of((String)"betteranimationscollection");
    public static final Map<ResourceLocation, ModelElementBase> MODEL_ELEMENTS = Maps.newHashMap();
    private static final Map<Class<? extends EntityModel<?>>, ModelElementBase.AnimatedModelData<?, ?>> ANIMATED_MODEL_DATA = Maps.newIdentityHashMap();
    private static boolean allowResourceReloading;

    public void onConstructMod() {
        BetterAnimationsCollectionClient.bootstrap();
        BetterAnimationsCollection.CONFIG.bakeConfigs("betteranimationscollection");
    }

    private static void bootstrap() {
        BetterAnimationsCollectionClient.registerModelElement("oinky_pig", OinkyPigElement::new);
        BetterAnimationsCollectionClient.registerModelElement("bucka_bucka_chicken", BuckaChickenElement::new);
        BetterAnimationsCollectionClient.registerModelElement("wiggly_ghast_tentacles", GhastTentaclesElement::new);
        BetterAnimationsCollectionClient.registerModelElement("squiggly_squid_tentacles", SquidTentaclesElement::new);
        BetterAnimationsCollectionClient.registerModelElement("kneeling_sheep", KneelingSheepElement::new);
        BetterAnimationsCollectionClient.registerModelElement("spider_knees", SpiderKneesElement::new);
        BetterAnimationsCollectionClient.registerModelElement("animated_snow_man_stick", SnowGolemStickElement::new);
        BetterAnimationsCollectionClient.registerModelElement("wobbly_cow_udder", CowUdderElement::new);
        BetterAnimationsCollectionClient.registerModelElement("wiggly_iron_golem_nose", IronGolemNoseElement::new);
        BetterAnimationsCollectionClient.registerModelElement("flowy_ocelot_tail", OcelotTailElement::new);
        BetterAnimationsCollectionClient.registerModelElement("curly_cat_tail", CatTailElement::new);
        BetterAnimationsCollectionClient.registerModelElement("wiggly_villager_nose", VillagerNoseElement::new);
        BetterAnimationsCollectionClient.registerModelElement("magma_cube_burger", MagmaCubeBurgerElement::new);
        BetterAnimationsCollectionClient.registerModelElement("jiggly_liquidy_slime", JigglySlimeElement::new);
        BetterAnimationsCollectionClient.registerModelElement("arm_flailing_enderman", FlailingEndermanElement::new);
        BetterAnimationsCollectionClient.registerModelElement("wobbly_creeper", WobblyCreeperElement::new);
        BetterAnimationsCollectionClient.registerModelElement("playful_doggy", PlayfulDoggyElement::new);
        BetterAnimationsCollectionClient.registerModelElement("bending_humanoid_knees", HumanoidKneesElement::new);
        BetterAnimationsCollectionClient.registerModelElement("familiar_horse", FamiliarHorseElement::new);
        BetterAnimationsCollectionClient.registerModelElement("spitful_llama", SpitfulLlamaElement::new);
    }

    private static void registerModelElement(String identifier, Function<ModelLayerRegistry, ModelElementBase> factory) {
        MODEL_ELEMENTS.put(new ResourceLocation("betteranimationscollection", identifier), factory.apply(MODEL_LAYER_REGISTRY));
    }

    public void onClientSetup() {
        BetterAnimationsCollectionClient.buildAnimatedModels(false, false);
        BetterAnimationsCollection.CONFIG.getHolder(ClientConfig.class).accept(() -> BetterAnimationsCollectionClient.buildAnimatedModels(true, true));
    }

    public static void buildAnimatedModels(boolean checkDirty, boolean reloadResourcePacks) {
        if (!checkDirty || MODEL_ELEMENTS.values().stream().anyMatch(ModelElementBase::isDirty)) {
            ANIMATED_MODEL_DATA.clear();
            ModelElementBase.AnimatedModelsContext context = new ModelElementBase.AnimatedModelsContext(){

                @Override
                public <T extends LivingEntity, M extends EntityModel<T>> void registerAnimatedModel(Class<? super M> vanillaModelClazz, Supplier<? extends M> animatedModel, ModelElementBase.LayerTransformer<T, M> layerTransformer) {
                    ANIMATED_MODEL_DATA.put(vanillaModelClazz, new ModelElementBase.AnimatedModelData<T, M>(vanillaModelClazz, animatedModel, layerTransformer));
                }
            };
            MODEL_ELEMENTS.values().forEach(element -> element.registerAnimatedModels(context, ModelElementBase.EntityModelBakery.of(() -> ((Minecraft)Minecraft.m_91087_()).m_167973_())));
            if (reloadResourcePacks && allowResourceReloading) {
                Minecraft.m_91087_().m_91391_();
            }
        }
    }

    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        MODEL_ELEMENTS.values().forEach(element -> element.onRegisterLayerDefinitions(context));
    }

    public void onRegisterClientReloadListeners(ClientModConstructor.ClientReloadListenersContext context) {
        context.registerReloadListener("animated_models", (preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2) -> preparationBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(BetterAnimationsCollectionClient::applyAnimatedModels, executor2));
    }

    public static <T extends LivingEntity, M extends EntityModel<T>> void applyAnimatedModels() {
        for (Map.Entry<EntityType<?>, EntityRenderer<?>> entry : ((EntityRenderDispatcherAccessor)Minecraft.m_91087_().m_91290_()).getRenderers().entrySet()) {
            ModelElementBase.AnimatedModelData<?, ?> animatedModelData;
            LivingEntityRenderer livingRenderer;
            if (((ClientConfig)BetterAnimationsCollection.CONFIG.get(ClientConfig.class)).mobBlacklist.contains(entry.getKey()) || !(entry.getValue() instanceof LivingEntityRenderer) || (livingRenderer = (LivingEntityRenderer)entry.getValue()).m_7200_() == null || (animatedModelData = ANIMATED_MODEL_DATA.get(livingRenderer.m_7200_().getClass())) == null) continue;
            ((LivingEntityRendererAccessor)livingRenderer).setModel((EntityModel)animatedModelData.animatedModel().get());
            ListIterator iterator = ((LivingEntityRendererAccessor)livingRenderer).getLayers().listIterator();
            while (iterator.hasNext()) {
                animatedModelData.layerTransformer().apply((RenderLayerParent<?, ?>)livingRenderer, iterator.next()).ifPresent(iterator::set);
            }
        }
        allowResourceReloading = true;
    }
}

