/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.forge;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.commands.ServerCommandBuilder;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.core.ServerCore;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.networking.NetworkHandler;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;
import nx.pingwheel.forge.Client;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="pingwheel")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Main {
    public static final String FORGE_ID = "pingwheel";
    private static final String PROTOCOL_VERSION = "1";
    public static final EventNetworkChannel PING_LOCATION_CHANNEL_C2S = NetworkRegistry.newEventChannel((ResourceLocation)PingLocationC2SPacket.PACKET_ID, () -> "1", c -> true, s -> true);
    public static final EventNetworkChannel PING_LOCATION_CHANNEL_S2C = NetworkRegistry.newEventChannel((ResourceLocation)PingLocationS2CPacket.PACKET_ID, () -> "1", c -> true, s -> true);
    public static final EventNetworkChannel UPDATE_CHANNEL_C2S = NetworkRegistry.newEventChannel((ResourceLocation)UpdateChannelC2SPacket.PACKET_ID, () -> "1", c -> true, s -> true);

    public Main() {
        Global.LOGGER.info("Init");
        Global.NetHandler = new NetworkHandler();
        Global.ServerConfigHandler = new ConfigHandler<ServerConfig>(ServerConfig.class, FMLPaths.CONFIGDIR.get().resolve("ping-wheel.server.json"));
        Global.ServerConfigHandler.load();
        Global.ModVersion = ModList.get().getModContainerById(FORGE_ID).map(container -> container.getModInfo().getVersion().toString()).orElse("Unknown");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Client::new);
        PING_LOCATION_CHANNEL_C2S.addListener(event -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            FriendlyByteBuf payload = event.getPayload();
            ServerPlayer sender = ctx.getSender();
            if (payload != null && sender != null) {
                PingLocationC2SPacket packet = PingLocationC2SPacket.readSafe(payload);
                ctx.enqueueWork(() -> ServerCore.onPingLocation(sender.m_20194_(), sender, packet));
            }
            ctx.setPacketHandled(true);
        });
        UPDATE_CHANNEL_C2S.addListener(event -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            FriendlyByteBuf payload = event.getPayload();
            if (payload != null) {
                UpdateChannelC2SPacket packet = UpdateChannelC2SPacket.readSafe(payload);
                ctx.enqueueWork(() -> ServerCore.onChannelUpdate(ctx.getSender(), packet));
            }
            ctx.setPacketHandled(true);
        });
        ServerCore.init();
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerCore.onPlayerDisconnect((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(ServerCommandBuilder.build((TriConsumer<CommandContext<CommandSourceStack>, Boolean, MutableComponent>)((TriConsumer)(context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)LanguageUtils.withModPrefix(response));
            }
        })));
    }
}

