/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.ClientGlobal;

public class Raycast {
    private Raycast() {
    }

    public static HitResult traceDirectional(Vec3 direction, float tickDelta, double maxDistance, boolean hitFluids) {
        Entity cameraEntity = ClientGlobal.Game.f_91075_;
        if (cameraEntity == null || cameraEntity.f_19853_ == null) {
            return null;
        }
        Vec3 rayStartVec = cameraEntity.m_20299_(tickDelta);
        Vec3 rayEndVec = rayStartVec.m_82549_(direction.m_82490_(maxDistance));
        AABB boundingBox = cameraEntity.m_20191_().m_82369_(cameraEntity.m_20252_(1.0f).m_82490_(maxDistance)).m_82377_(1.0, 1.0, 1.0);
        BlockHitResult blockHitResult = cameraEntity.f_19853_.m_45547_(new ClipContext(rayStartVec, rayEndVec, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, cameraEntity));
        EntityHitResult entityHitResult = Raycast.traceEntity(cameraEntity, rayStartVec, rayEndVec, boundingBox, targetEntity -> !targetEntity.m_5833_());
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (rayStartVec.m_82557_(blockHitResult.m_82450_()) < rayStartVec.m_82557_(entityHitResult.m_82450_())) {
            return blockHitResult;
        }
        return entityHitResult;
    }

    private static EntityHitResult traceEntity(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate) {
        double minDist = min.m_82557_(max);
        EntityHitResult minHitResult = null;
        for (Entity ent : entity.f_19853_.m_6249_(entity, box, predicate)) {
            EntityHitResult hitResult;
            double hitDist;
            AABB targetBoundingBox = ent.m_20191_().m_82400_((double)ent.m_6143_()).m_82400_(0.25);
            Optional hitPos = targetBoundingBox.m_82371_(min, max);
            if (hitPos.isEmpty() || !(minDist > (hitDist = min.m_82557_((hitResult = new EntityHitResult(ent, (Vec3)hitPos.get())).m_82450_())))) continue;
            minDist = hitDist;
            minHitResult = hitResult;
        }
        return minHitResult;
    }
}

