/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.blaze3d.platform.Window;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.ScreenPos;
import org.jetbrains.annotations.Nullable;

public class Ping {
    private static final ClientConfig Config = ClientGlobal.ConfigHandler.getConfig();
    private Vec3 pos;
    @Nullable
    private final UUID uuid;
    private final PlayerInfo author;
    private final int sequence;
    private final int dimension;
    private final int spawnTime;
    private int age;
    private double distance;
    @Nullable
    private ScreenPos screenPos;
    @Nullable
    private ItemStack itemStack;

    public Ping(Vec3 pos, @Nullable UUID uuid, PlayerInfo author, int sequence, int dimension, int spawnTime) {
        this.pos = pos;
        this.uuid = uuid;
        this.author = author;
        this.sequence = sequence;
        this.dimension = dimension;
        this.spawnTime = spawnTime;
    }

    public boolean isExpired() {
        return Config.getPingDuration() < 60 && this.age > Config.getPingDuration() * 20;
    }

    public boolean isRemovable() {
        return (Config.getCorrectionPeriod() >= 5.0f || (float)this.age > Config.getCorrectionPeriod() * 20.0f) && this.distanceToCenter() < (float)Config.getRemoveRadius();
    }

    public float distanceToCenter() {
        if (this.screenPos == null) {
            return 0.0f;
        }
        Window wnd = ClientGlobal.Game.m_91268_();
        Vec2 center = new Vec2((float)wnd.m_85445_() * 0.5f, (float)wnd.m_85446_() * 0.5f);
        return this.screenPos.distanceTo(center);
    }

    public boolean isCloserToCenter(@Nullable Ping b) {
        if (b == null) {
            return true;
        }
        return this.distanceToCenter() < b.distanceToCenter();
    }

    public Vec3 getPos() {
        return this.pos;
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public PlayerInfo getAuthor() {
        return this.author;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSpawnTime() {
        return this.spawnTime;
    }

    public int getAge() {
        return this.age;
    }

    public double getDistance() {
        return this.distance;
    }

    @Nullable
    public ScreenPos getScreenPos() {
        return this.screenPos;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setScreenPos(@Nullable ScreenPos screenPos) {
        this.screenPos = screenPos;
    }

    public void setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

