/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.DrawContext;
import nx.pingwheel.common.helper.InputUtils;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.helper.Ping;
import nx.pingwheel.common.helper.Raycast;
import nx.pingwheel.common.helper.ScreenPos;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.common.sound.DirectionalSoundInstance;

public class ClientCore {
    private static final ClientConfig Config = ClientGlobal.ConfigHandler.getConfig();
    private static final ArrayList<Ping> pingRepo = new ArrayList();
    private static boolean pingQueued = false;
    private static ClientLevel lastWorld = null;
    private static int dimension = 0;
    private static int lastPing = 0;
    private static int pingSequence = 0;

    private ClientCore() {
    }

    public static void onDisconnect() {
        pingRepo.clear();
    }

    public static void onTick() {
        if (InputUtils.consumePingHotkey()) {
            pingQueued = true;
        }
        if (ClientGlobal.KEY_BINDING_SETTINGS.m_90859_()) {
            ClientGlobal.Game.m_91152_((Screen)new SettingsScreen());
        }
    }

    public static void onPingLocation(PingLocationS2CPacket packet) {
        Vec3 vecToPing;
        if (packet.isCorrupt()) {
            Global.LOGGER.warn("received invalid ping location from server");
            return;
        }
        ClientPacketListener connection = ClientGlobal.Game.m_91403_();
        if (ClientGlobal.Game.f_91074_ == null || ClientGlobal.Game.f_91073_ == null || connection == null) {
            return;
        }
        if (!packet.channel().equals(Config.getChannel())) {
            return;
        }
        if (Config.getPingDistance() < 2048 && (vecToPing = ClientGlobal.Game.f_91074_.m_20182_().m_82505_(packet.pos())).m_82553_() > (double)Config.getPingDistance()) {
            return;
        }
        PlayerInfo authorInfo = connection.m_104949_(packet.author());
        ClientGlobal.Game.execute(() -> {
            ClientCore.addOrReplacePing(new Ping(packet.pos(), packet.entity(), authorInfo, packet.sequence(), packet.dimension(), (int)ClientGlobal.Game.f_91073_.m_46467_()));
            if (packet.dimension() == dimension) {
                ClientGlobal.Game.m_91106_().m_120367_((SoundInstance)new DirectionalSoundInstance(ClientGlobal.PING_SOUND_EVENT, SoundSource.MASTER, (float)Config.getPingVolume() / 100.0f, 1.0f, packet.pos()));
            }
        });
    }

    public static void onRenderWorld(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta) {
        if (ClientGlobal.Game.f_91073_ == null) {
            return;
        }
        if (lastWorld != ClientGlobal.Game.f_91073_) {
            lastWorld = ClientGlobal.Game.f_91073_;
            dimension = lastWorld.m_46472_().m_135782_().hashCode();
        }
        int time = (int)ClientGlobal.Game.f_91073_.m_46467_();
        ClientCore.processPings(modelViewMatrix, projectionMatrix, tickDelta, time);
        if (pingQueued) {
            if (Config.getCorrectionPeriod() < 5.0f && (float)(time - lastPing) > Config.getCorrectionPeriod() * 20.0f) {
                ++pingSequence;
            }
            lastPing = time;
            pingQueued = false;
            ClientCore.executePing(tickDelta);
        }
    }

    public static void onRenderGUI(PoseStack m, float tickDelta) {
        if (ClientGlobal.Game.f_91074_ == null || pingRepo.isEmpty()) {
            return;
        }
        DrawContext ctx = new DrawContext(m);
        Window wnd = ClientGlobal.Game.m_91268_();
        Vec2 screenSize = new Vec2((float)wnd.m_85445_(), (float)wnd.m_85446_());
        Vec2 safeZoneTopLeft = new Vec2((float)Config.getSafeZoneLeft(), (float)Config.getSafeZoneTop());
        Vec2 safeZoneBottomRight = new Vec2(screenSize.f_82470_ - (float)Config.getSafeZoneRight(), screenSize.f_82471_ - (float)Config.getSafeZoneBottom());
        Vec2 safeScreenCenter = new Vec2((safeZoneBottomRight.f_82470_ - safeZoneTopLeft.f_82470_) * 0.5f, (safeZoneBottomRight.f_82471_ - safeZoneTopLeft.f_82471_) * 0.5f);
        boolean showDirectionIndicator = Config.isDirectionIndicatorVisible();
        boolean showNameLabels = Config.isNameLabelForced() || ClientGlobal.KEY_BINDING_NAME_LABELS.m_90857_();
        m.m_85836_();
        m.m_85837_(0.0, 0.0, (double)((float)(-pingRepo.size()) * 16.0f));
        for (Ping ping : pingRepo) {
            boolean isOffScreen;
            ScreenPos screenPos = ping.getScreenPos();
            if (screenPos == null || ping.getDimension() != dimension || screenPos.isBehindCamera() && !showDirectionIndicator) continue;
            m.m_85837_(0.0, 0.0, 16.0);
            float pingSize = (float)Config.getPingSize() / 100.0f;
            float pingScale = ClientCore.getDistanceScale(ping.getDistance()) * pingSize * 0.4f;
            Vec2 pingDirectionVec = new Vec2(screenPos.x - safeZoneTopLeft.f_82470_ - safeScreenCenter.f_82470_, screenPos.y - safeZoneTopLeft.f_82471_ - safeScreenCenter.f_82471_);
            boolean behindCamera = screenPos.isBehindCamera();
            if (behindCamera) {
                pingDirectionVec = pingDirectionVec.m_165903_(-1.0f);
            }
            float pingAngle = (float)Math.atan2(pingDirectionVec.f_82471_, pingDirectionVec.f_82470_);
            boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(Vec2.f_82462_, screenSize);
            if (isOffScreen && showDirectionIndicator) {
                Vec2 indicator = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
                m.m_85836_();
                m.m_85837_((double)indicator.f_82470_, (double)indicator.f_82471_, 0.0);
                m.m_85836_();
                m.m_85841_(pingScale, pingScale, 1.0f);
                double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
                double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
                m.m_85837_(indicatorOffsetX, indicatorOffsetY, 0.0);
                ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
                m.m_85849_();
                m.m_85836_();
                MathUtils.rotateZ(m, pingAngle);
                m.m_85841_(pingSize, pingSize, 1.0f);
                m.m_85841_(0.25f, 0.25f, 1.0f);
                m.m_85837_(-5.0, 0.0, 0.0);
                ctx.renderArrow(true);
                m.m_85841_(0.9f, 0.9f, 1.0f);
                ctx.renderArrow(false);
                m.m_85849_();
                m.m_85849_();
            }
            if (behindCamera) continue;
            m.m_85836_();
            m.m_85837_((double)screenPos.x, (double)screenPos.y, 0.0);
            m.m_85841_(pingScale, pingScale, 1.0f);
            MutableComponent text = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
            ctx.renderLabel((Component)text, -1.5f, null);
            ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
            PlayerInfo author = ping.getAuthor();
            if (showNameLabels && author != null) {
                MutableComponent displayName = PlayerTeam.m_83348_((Team)author.m_105340_(), (Component)Component.m_237113_((String)author.m_105312_().getName()));
                ctx.renderLabel((Component)displayName, 1.75f, author);
            }
            m.m_85849_();
        }
        m.m_85849_();
    }

    private static void processPings(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta, int time) {
        if (ClientGlobal.Game.f_91074_ == null || pingRepo.isEmpty()) {
            return;
        }
        Vec3 cameraPos = ClientGlobal.Game.f_91074_.m_20299_(tickDelta);
        Ping target = null;
        Iterator<Ping> iter = pingRepo.iterator();
        while (iter.hasNext()) {
            Entity ent;
            Ping ping = iter.next();
            if (ping.getUuid() != null && (ent = ClientCore.getEntity(ping.getUuid())) != null) {
                if (ent.m_6095_() == EntityType.f_20461_ && Config.isItemIconVisible()) {
                    ping.setItemStack(((ItemEntity)ent).m_32055_().m_41777_());
                }
                ping.setPos(ent.m_20318_(tickDelta).m_82520_(0.0, ent.m_20191_().m_82376_(), 0.0));
            }
            ping.setDistance(cameraPos.m_82554_(ping.getPos()));
            ping.setScreenPos(MathUtils.worldToScreen(ping.getPos(), modelViewMatrix, projectionMatrix));
            ping.setAge(time - ping.getSpawnTime());
            if (ping.isExpired()) {
                iter.remove();
                continue;
            }
            if (!pingQueued || !ping.isRemovable() || !ping.isCloserToCenter(target)) continue;
            target = ping;
        }
        if (target != null && pingRepo.remove(target)) {
            pingQueued = false;
        }
        pingRepo.sort((a, b) -> Double.compare(b.getDistance(), a.getDistance()));
    }

    private static void executePing(float tickDelta) {
        Entity cameraEntity = ClientGlobal.Game.f_91075_;
        if (cameraEntity == null || ClientGlobal.Game.f_91073_ == null) {
            return;
        }
        Vec3 cameraDirection = cameraEntity.m_20252_(tickDelta);
        HitResult hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(Config.getRaycastDistance(), Config.getPingDistance()), cameraEntity.m_6047_());
        if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        UUID uuid = null;
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            uuid = ((EntityHitResult)hitResult).m_82443_().m_20148_();
        }
        Global.NetHandler.sendToServer(new PingLocationC2SPacket(Config.getChannel(), hitResult.m_82450_(), uuid, pingSequence, dimension));
    }

    private static void addOrReplacePing(Ping newPing) {
        int index = -1;
        for (int i = 0; i < pingRepo.size(); ++i) {
            Ping entry = pingRepo.get(i);
            if (!Objects.equals(entry.getAuthor(), newPing.getAuthor()) || entry.getSequence() != newPing.getSequence()) continue;
            index = i;
            break;
        }
        if (index != -1) {
            pingRepo.set(index, newPing);
        } else {
            pingRepo.add(newPing);
        }
    }

    private static Entity getEntity(UUID uuid) {
        if (ClientGlobal.Game.f_91073_ == null) {
            return null;
        }
        for (Entity entity : ClientGlobal.Game.f_91073_.m_104735_()) {
            if (!entity.m_20148_().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private static float getDistanceScale(double distance) {
        double scale = 2.0 / Math.pow(distance, 0.3);
        return (float)Math.max(1.0, scale);
    }
}

