/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;
import tictim.paraglider.wind.WindWriter;

public class WindUpdater {
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MIN = -11;
    private static final int PARAGLIDING_Y_MAX = 1;
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
    private final Set<WindChunk> modifiedChunks = new HashSet<WindChunk>();

    public Set<WindChunk> getModifiedChunks() {
        return this.modifiedChunks;
    }

    public void placeAround(Player player) {
        int x = Mth.m_14107_((double)player.m_20185_());
        int y = Mth.m_14107_((double)player.m_20186_());
        int z = Mth.m_14107_((double)player.m_20189_());
        this.place(player.f_19853_, x - 4, y + (player.m_20096_() ? -2 : -11), z - 4, x + 4, y + (player.m_20096_() ? 4 : 1), z + 4);
    }

    public void place(Level world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            ParagliderMod.LOGGER.warn("Cannot place wind because there's no Wind capability associated with world {}", (Object)world);
            return;
        }
        WindWriter writer = new WindWriter(wind, world.m_46467_());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                writer.setXZ(x, z);
                boolean hasFireY = false;
                int fireY = 0;
                int y = minY;
                while (true) {
                    block10: {
                        boolean isWindSource;
                        block9: {
                            this.mpos.m_122178_(x, y, z);
                            BlockState state = world.m_8055_((BlockPos)this.mpos);
                            isWindSource = ModCfg.isWindSource(state);
                            if (!hasFireY) break block9;
                            int height = y - fireY;
                            if (height < 10 && !isWindSource && !state.m_60767_().m_76334_() && !Block.m_49863_((LevelReader)world, (BlockPos)this.mpos, (Direction)Direction.DOWN) && !Block.m_49863_((LevelReader)world, (BlockPos)this.mpos, (Direction)Direction.UP)) break block10;
                            if (height > 2) {
                                writer.wind(fireY, height);
                            }
                            hasFireY = false;
                        }
                        if (y > maxY) break;
                        if (isWindSource) {
                            fireY = y;
                            hasFireY = true;
                        }
                    }
                    ++y;
                }
                writer.end();
            }
        }
        this.modifiedChunks.addAll(writer.getModifiedChunks());
    }

    public void checkPlacedWind(Level world) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return;
        }
        for (WindChunk windChunk : wind.getWindChunks()) {
            Collection<WindNode> allRootNodes = windChunk.getAllRootNodes();
            for (WindNode node : allRootNodes.toArray(new WindNode[0])) {
                WindNode updated = this.validate(windChunk, node, world);
                if (updated == node) continue;
                if (updated == null) {
                    windChunk.removeAllNodesInXZ(node.x, node.z);
                    continue;
                }
                windChunk.putNode(updated);
            }
        }
    }

    @Nullable
    private WindNode validate(WindChunk windChunk, WindNode node, Level world) {
        long gameTime = world.m_46467_();
        if (node.updatedTime != gameTime) {
            if (node.isExpired(gameTime) || !ModCfg.isWindSource(world.m_8055_((BlockPos)this.mpos.m_122178_(node.x, node.y, node.z)))) {
                this.modifiedChunks.add(windChunk);
                return node.next != null ? this.validate(windChunk, node.next, world) : null;
            }
            node.updatedTime = gameTime;
        }
        if (node.next != null) {
            node.next = this.validate(windChunk, node.next, world);
        }
        return node;
    }
}

