/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import tictim.paraglider.capabilities.Caps;
import tictim.paraglider.wind.WindChunk;

public class Wind
implements ICapabilityProvider {
    private final Long2ObjectMap<WindChunk> windChunks = new Long2ObjectOpenHashMap();
    private final LazyOptional<Wind> self = LazyOptional.of(() -> this);

    public void put(WindChunk windChunk) {
        this.windChunks.put(windChunk.getChunkPos().m_45588_(), (Object)windChunk);
    }

    @Nullable
    public WindChunk get(int chunkX, int chunkZ) {
        return (WindChunk)this.windChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk get(ChunkPos chunkPos) {
        return (WindChunk)this.windChunks.get(chunkPos.m_45588_());
    }

    public WindChunk getOrCreate(int chunkX, int chunkZ) {
        WindChunk windChunk = this.get(chunkX, chunkZ);
        if (windChunk != null) {
            return windChunk;
        }
        windChunk = new WindChunk(new ChunkPos(chunkX, chunkZ));
        this.put(windChunk);
        return windChunk;
    }

    public WindChunk getOrCreate(ChunkPos chunkPos) {
        WindChunk windChunk = this.get(chunkPos);
        if (windChunk != null) {
            return windChunk;
        }
        windChunk = new WindChunk(chunkPos);
        this.put(windChunk);
        return windChunk;
    }

    @Nullable
    public WindChunk remove(int chunkX, int chunkZ) {
        return (WindChunk)this.windChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk remove(ChunkPos chunkPos) {
        return (WindChunk)this.windChunks.remove(chunkPos.m_45588_());
    }

    public Collection<WindChunk> getWindChunks() {
        return this.windChunks.values();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == Caps.wind ? this.self.cast() : LazyOptional.empty();
    }

    @Nullable
    public static Wind of(ICapabilityProvider capabilityProvider) {
        return (Wind)capabilityProvider.getCapability(Caps.wind).orElse(null);
    }

    public static boolean isInside(Level world, AABB boundingBox) {
        return Wind.isInside(world, Mth.m_14107_((double)boundingBox.f_82288_), Mth.m_14107_((double)boundingBox.f_82289_), Mth.m_14107_((double)boundingBox.f_82290_), Mth.m_14165_((double)boundingBox.f_82291_), Mth.m_14165_((double)boundingBox.f_82292_), Mth.m_14165_((double)boundingBox.f_82293_));
    }

    public static boolean isInside(Level world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return false;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.get(x, z);
                if (windChunk == null || !windChunk.isInsideWind(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
        }
        return false;
    }
}

