/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import tictim.paraglider.contents.recipe.bargain.BargainResult;
import tictim.paraglider.contents.recipe.bargain.StatueBargain;

public final class StatueDialog {
    private static final Random RNG = new Random();
    private final Map<Case, Dialogs> map = new EnumMap<Case, Dialogs>(Case.class);

    public StatueDialog() {
        for (Case c : Case.values()) {
            this.map.put(c, new Dialogs());
        }
    }

    public StatueDialog atInitial(String translationKey) {
        return this.add(Case.INITIAL, (Component)Component.m_237115_((String)translationKey));
    }

    public StatueDialog atSuccess(String translationKey) {
        return this.add(Case.BARGAIN_SUCCESS, (Component)Component.m_237115_((String)translationKey));
    }

    public StatueDialog atSuccess(String translationKey, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        return this.add(Case.BARGAIN_SUCCESS, (Component)Component.m_237115_((String)translationKey), predicate);
    }

    public StatueDialog atSuccessFallback(String translationKey) {
        return this.setFallback(Case.BARGAIN_SUCCESS, (Component)Component.m_237115_((String)translationKey));
    }

    public StatueDialog atFailure(String translationKey) {
        return this.add(Case.BARGAIN_FAILURE, (Component)Component.m_237115_((String)translationKey));
    }

    public StatueDialog atFailure(String translationKey, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        return this.add(Case.BARGAIN_FAILURE, (Component)Component.m_237115_((String)translationKey), predicate);
    }

    public StatueDialog atFailureFallback(String translationKey) {
        return this.setFallback(Case.BARGAIN_FAILURE, (Component)Component.m_237115_((String)translationKey));
    }

    public StatueDialog add(Case dialogCase, Component text) {
        return this.add(dialogCase, text, null);
    }

    public StatueDialog add(Case dialogCase, Component text, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        this.map.get((Object)((Object)dialogCase)).dialog.add(new Dialog(predicate, Objects.requireNonNull(text)));
        return this;
    }

    public StatueDialog setFallback(Case dialogCase, Component text) {
        return this.setFallback(dialogCase, text, null);
    }

    public StatueDialog setFallback(Case dialogCase, Component text, @Nullable BiPredicate<StatueBargain, BargainResult> predicate) {
        this.map.get((Object)((Object)dialogCase)).fallback = new Dialog(predicate, Objects.requireNonNull(text));
        return this;
    }

    @Nullable
    public Component getDialog(Case dialogCase, @Nullable StatueBargain bargain, @Nullable BargainResult result) {
        return this.map.get((Object)dialogCase).getDialog(bargain, result);
    }

    public static enum Case {
        INITIAL,
        BARGAIN_SUCCESS,
        BARGAIN_FAILURE;

    }

    private static final class Dialogs {
        private final List<Dialog> dialog = new ArrayList<Dialog>();
        @Nullable
        private Dialog fallback;

        private Dialogs() {
        }

        @Nullable
        public Component getDialog(@Nullable StatueBargain bargain, @Nullable BargainResult bargainResult) {
            ArrayList<Dialog> dialogs = new ArrayList<Dialog>();
            for (Dialog f : this.dialog) {
                if (bargain != null && bargainResult != null && f.predicate != null && !f.predicate.test(bargain, bargainResult)) continue;
                dialogs.add(f);
            }
            Dialog chosenDialog = dialogs.isEmpty() ? this.fallback : (Dialog)dialogs.get(RNG.nextInt(dialogs.size()));
            return chosenDialog != null ? chosenDialog.text : null;
        }
    }

    private record Dialog(@Nullable BiPredicate<StatueBargain, BargainResult> predicate, Component text) {
    }
}

