/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe.bargain;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.recipe.bargain.BargainResult;
import tictim.paraglider.contents.recipe.bargain.StatueBargain;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.StatueDialogMsg;
import tictim.paraglider.network.SyncLookAtMsg;
import tictim.paraglider.network.UpdateBargainPreviewMsg;
import tictim.paraglider.utils.StatueDialog;

public class StatueBargainContainer
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final List<StatueBargain> bargains;
    @Nullable
    private final StatueDialog dialog;
    @Nullable
    private ResourceLocation advancement;
    private int heartContainerCache;
    private int staminaVesselCache;
    private int essenceCache;
    private final Preview[] previousBargainTest;
    private final NonNullList<ItemStack> inventoryCache;
    @Nullable
    private Vec3 lookAt;
    @Nullable
    private Vec3 prevLookAt;
    private boolean redoBargainTest = true;
    private boolean sendInitMessage = true;

    public StatueBargainContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory) {
        this(type, id, playerInventory, null, null);
    }

    public StatueBargainContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory, @Nullable StatueDialog dialog, @Nullable ResourceLocation advancement) {
        super(type, id);
        int i;
        this.playerInventory = playerInventory;
        this.dialog = dialog;
        this.advancement = advancement;
        ResourceLocation menuTypeId = type == null ? null : ForgeRegistries.MENU_TYPES.getKey(type);
        this.bargains = playerInventory.f_35978_.f_19853_.m_7465_().m_44013_((RecipeType)Contents.STATUE_BARGAIN_RECIPE_TYPE.get()).stream().filter(b -> type == null || b.getBargainOwner().equals((Object)menuTypeId)).sorted(Comparator.comparing(Recipe::m_6423_)).collect(Collectors.toList());
        this.previousBargainTest = new Preview[this.bargains.size()];
        for (i = 0; i < this.previousBargainTest.length; ++i) {
            this.previousBargainTest[i] = new Preview();
        }
        this.inventoryCache = NonNullList.m_122780_((int)playerInventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack stack = playerInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.inventoryCache.set(i, (Object)stack.m_41777_());
        }
    }

    public List<StatueBargain> getBargains() {
        return this.bargains;
    }

    @Nullable
    public StatueBargain getBargain(int bargainIndex) {
        if (bargainIndex < 0) {
            return null;
        }
        return this.bargains.size() > bargainIndex ? this.bargains.get(bargainIndex) : null;
    }

    public boolean canBargain(int bargainIndex) {
        if (bargainIndex < 0) {
            return false;
        }
        return this.previousBargainTest.length > bargainIndex && this.previousBargainTest[bargainIndex].canBargain;
    }

    public ItemDemand[] getDemandPreview(int bargainIndex) {
        if (bargainIndex < 0) {
            return new ItemDemand[0];
        }
        return this.previousBargainTest.length > bargainIndex ? this.previousBargainTest[bargainIndex].demands : new ItemDemand[]{};
    }

    @Nullable
    public Vec3 getLookAt() {
        return this.lookAt;
    }

    public void setLookAt(@Nullable Vec3 lookAt) {
        this.lookAt = lookAt;
    }

    @Nullable
    public ResourceLocation getAdvancement() {
        return this.advancement;
    }

    public void setAdvancement(@Nullable ResourceLocation advancement) {
        this.advancement = advancement;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_38946_() {
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)this.playerInventory.f_35978_);
        if (m != null) {
            if (this.heartContainerCache != m.getHeartContainers()) {
                this.redoBargainTest = true;
                this.heartContainerCache = m.getHeartContainers();
            }
            if (this.staminaVesselCache != m.getStaminaVessels()) {
                this.redoBargainTest = true;
                this.staminaVesselCache = m.getStaminaVessels();
            }
            if (this.essenceCache != m.getEssence()) {
                this.redoBargainTest = true;
                this.essenceCache = m.getEssence();
            }
        }
        if (this.inventoryChanged()) {
            this.redoBargainTest = true;
        }
        if (this.redoBargainTest) {
            this.updateBargainTest();
        }
        if (this.sendInitMessage) {
            this.sendInitMessage = false;
            this.sendDialog(StatueDialog.Case.INITIAL, null, null);
        }
        if (this.prevLookAt != this.lookAt) {
            this.prevLookAt = this.lookAt;
            this.sendToPlayer(new SyncLookAtMsg(this.lookAt));
        }
        super.m_38946_();
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    private boolean inventoryChanged() {
        boolean changed = false;
        for (int i = 0; i < this.playerInventory.m_6643_(); ++i) {
            ItemStack s1 = this.playerInventory.m_8020_(i);
            ItemStack s2 = (ItemStack)this.inventoryCache.get(i);
            if (ItemStack.m_41728_((ItemStack)s2, (ItemStack)s1)) continue;
            ItemStack copy = s1.m_41777_();
            this.inventoryCache.set(i, (Object)copy);
            changed = true;
        }
        return changed;
    }

    private void updateBargainTest() {
        UpdateBargainPreviewMsg msg = null;
        for (int i = 0; i < this.bargains.size(); ++i) {
            Preview preview = this.previousBargainTest[i];
            StatueBargain bargain = this.bargains.get(i);
            boolean canBargainUpdated = preview.updateCanBargain(bargain, this.playerInventory.f_35978_);
            boolean demandPreviewUpdated = preview.updateDemandPreview(bargain, this.playerInventory.f_35978_);
            if (!canBargainUpdated && !demandPreviewUpdated) continue;
            if (msg == null) {
                msg = new UpdateBargainPreviewMsg();
            }
            msg.add(bargain.m_6423_(), preview, demandPreviewUpdated);
        }
        if (msg != null) {
            this.sendToPlayer(msg);
        }
        this.redoBargainTest = false;
    }

    public void sendDialog(StatueBargain bargain, BargainResult result) {
        this.sendDialog(result.isSuccess() ? StatueDialog.Case.BARGAIN_SUCCESS : StatueDialog.Case.BARGAIN_FAILURE, bargain, result);
    }

    private void sendDialog(StatueDialog.Case dialogCase, @Nullable StatueBargain bargain, @Nullable BargainResult result) {
        if (this.dialog == null) {
            return;
        }
        Component dialog = this.dialog.getDialog(dialogCase, bargain, result);
        if (dialog != null) {
            this.sendToPlayer(new StatueDialogMsg(dialog));
        }
    }

    private void sendToPlayer(Object message) {
        Player player = this.playerInventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), message);
        }
    }

    public void setCanBargain(ResourceLocation key, boolean booleanValue) {
        List<StatueBargain> bargains = this.getBargains();
        int bargainsSize = bargains.size();
        for (int i = 0; i < bargainsSize; ++i) {
            StatueBargain bargain = bargains.get(i);
            if (!key.equals((Object)bargain.m_6423_())) continue;
            this.previousBargainTest[i].setCanBargain(booleanValue);
            return;
        }
    }

    public void setDemandPreview(ResourceLocation key, ItemDemand[] demands) {
        List<StatueBargain> bargains = this.getBargains();
        int bargainsSize = bargains.size();
        for (int i = 0; i < bargainsSize; ++i) {
            StatueBargain bargain = bargains.get(i);
            if (!key.equals((Object)bargain.m_6423_())) continue;
            this.previousBargainTest[i].setDemands(demands);
            return;
        }
    }

    public static final class Preview {
        private boolean canBargain;
        private ItemDemand[] demands = new ItemDemand[0];

        public boolean canBargain() {
            return this.canBargain;
        }

        public void setCanBargain(boolean canBargain) {
            this.canBargain = canBargain;
        }

        public ItemDemand[] getDemands() {
            return this.demands;
        }

        public void setDemands(ItemDemand[] demands) {
            this.demands = demands;
        }

        public boolean updateCanBargain(StatueBargain bargain, Player player) {
            boolean canBargain = bargain.bargain(player, true).isSuccess();
            if (this.canBargain == canBargain) {
                return false;
            }
            this.canBargain = canBargain;
            return true;
        }

        public boolean updateDemandPreview(StatueBargain bargain, Player player) {
            ItemDemand[] demands = (ItemDemand[])bargain.getPreview().demands().stream().map(demand -> new ItemDemand(demand.getPreviewItems(), demand.getQuantity(), demand.getCounter().count(player))).toArray(ItemDemand[]::new);
            if (Preview.isSame(this.demands, demands)) {
                return false;
            }
            this.demands = demands;
            return true;
        }

        private static boolean isSame(ItemDemand[] a1, ItemDemand[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i].count == a2[i].count) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ItemDemand {
        private final ItemStack[] previewItems;
        private final int quantity;
        private final int count;

        public ItemDemand(ItemStack[] previewItems, int quantity, int count) {
            this.previewItems = previewItems;
            this.quantity = quantity;
            this.count = count;
        }

        public ItemStack[] getPreviewItems() {
            return this.previewItems;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public int getCount() {
            return this.count;
        }
    }
}

