/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.Stamina;
import tictim.paraglider.client.overlay.StaminaWheelOverlay;
import tictim.paraglider.client.screen.StatueBargainScreen;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ModVillageStructures;
import tictim.paraglider.contents.item.ParagliderItem;
import tictim.paraglider.contents.recipe.ConfigConditionSerializer;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.wind.Wind;

@Mod(value="paraglider")
@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParagliderMod {
    public static final String MODID = "paraglider";
    public static final Logger LOGGER = LogManager.getLogger((String)"Paraglider");

    public ParagliderMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Contents.registerEventHandlers(eventBus);
        ModCfg.init();
        ModNet.init();
        for (ConfigConditionSerializer c : ConfigConditionSerializer.values()) {
            CraftingHelper.register((IConditionSerializer)c);
        }
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModVillageStructures.addVillageStructures();
            CauldronInteraction.f_175607_.put((Item)Contents.PARAGLIDER.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)Contents.DEKU_LEAF.get(), CauldronInteraction.f_175615_);
        });
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerMovement.class);
        event.register(Paraglider.class);
        event.register(Wind.class);
        event.register(Stamina.class);
    }

    @SubscribeEvent
    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)Contents.MAX_STAMINA.get());
    }

    @Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static final class ClientHandler {
        private ClientHandler() {
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemPropertyFunction itemPropertyGetter = (stack, world, entity, i) -> entity instanceof Player && ParagliderItem.isItemParagliding(stack) ? 1.0f : 0.0f;
                ItemProperties.register((Item)((Item)Contents.PARAGLIDER.get()), (ResourceLocation)new ResourceLocation("paragliding"), (ItemPropertyFunction)itemPropertyGetter);
                ItemProperties.register((Item)((Item)Contents.DEKU_LEAF.get()), (ResourceLocation)new ResourceLocation("paragliding"), (ItemPropertyFunction)itemPropertyGetter);
                MenuScreens.ScreenConstructor f = StatueBargainScreen::new;
                MenuScreens.m_96206_((MenuType)((MenuType)Contents.GODDESS_STATUE_CONTAINER.get()), (MenuScreens.ScreenConstructor)f);
                MenuScreens.m_96206_((MenuType)((MenuType)Contents.HORNED_STATUE_CONTAINER.get()), (MenuScreens.ScreenConstructor)f);
            });
        }

        @SubscribeEvent
        public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
            event.register((stack, tint) -> tint > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)Contents.PARAGLIDER.get(), (ItemLike)Contents.DEKU_LEAF.get()});
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("stamina_wheel", (IGuiOverlay)new StaminaWheelOverlay());
        }
    }
}

