/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ClientSetting {
    public static final ClientSetting UNSYNCED_INSTANCE = new Default();

    public abstract boolean getPossibilityOf(Class<? extends Action> var1);

    public abstract int getStaminaConsumptionOf(Class<? extends Action> var1);

    public abstract Boolean get(ParCoolConfig.Client.Booleans var1);

    public abstract Integer get(ParCoolConfig.Client.Integers var1);

    public abstract Double get(ParCoolConfig.Client.Doubles var1);

    @OnlyIn(value=Dist.CLIENT)
    public static ClientSetting readFromLocalConfig() {
        Remote instance = new Remote();
        for (int i = 0; i < instance.actionPossibilities.length; ++i) {
            instance.actionPossibilities[i] = (Boolean)ParCoolConfig.Client.getPossibilityOf(ActionList.ACTIONS.get(i)).get();
            instance.staminaConsumptions[i] = (Integer)ParCoolConfig.Client.getStaminaConsumptionOf(ActionList.ACTIONS.get(i)).get();
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            instance.booleans.put(booleans, booleans.get());
        }
        for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
            instance.integers.put((ParCoolConfig.Client.Integers)enum_, ((ParCoolConfig.Client.Integers)enum_).get());
        }
        for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
            instance.doubles.put((ParCoolConfig.Client.Doubles)enum_, ((ParCoolConfig.Client.Doubles)enum_).get());
        }
        return instance;
    }

    public void writeTo(ByteBuffer buffer) {
        for (Class<? extends Action> action : ActionList.ACTIONS) {
            buffer.put((byte)(this.getPossibilityOf(action) ? 1 : 0));
            buffer.putInt(this.getStaminaConsumptionOf(action));
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            buffer.put((byte)(this.get(booleans) != false ? 1 : 0));
        }
        for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
            buffer.putInt(this.get((ParCoolConfig.Client.Integers)enum_));
        }
        for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
            buffer.putDouble(this.get((ParCoolConfig.Client.Doubles)enum_));
        }
    }

    public static ClientSetting readFrom(ByteBuffer buffer) {
        Remote instance = new Remote();
        for (int i = 0; i < instance.actionPossibilities.length; ++i) {
            instance.actionPossibilities[i] = buffer.get() != 0;
            instance.staminaConsumptions[i] = buffer.getInt();
        }
        for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
            instance.booleans.put(booleans, booleans.readFromBuffer(buffer));
        }
        for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
            instance.integers.put((ParCoolConfig.Client.Integers)enum_, ((ParCoolConfig.Client.Integers)enum_).readFromBuffer(buffer));
        }
        for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
            instance.doubles.put((ParCoolConfig.Client.Doubles)enum_, ((ParCoolConfig.Client.Doubles)enum_).readFromBuffer(buffer));
        }
        return instance;
    }

    private static class Remote
    extends ClientSetting {
        private final boolean[] actionPossibilities = new boolean[ActionList.ACTIONS.size()];
        private final int[] staminaConsumptions = new int[ActionList.ACTIONS.size()];
        private final EnumMap<ParCoolConfig.Client.Booleans, Boolean> booleans = new EnumMap(ParCoolConfig.Client.Booleans.class);
        private final EnumMap<ParCoolConfig.Client.Integers, Integer> integers = new EnumMap(ParCoolConfig.Client.Integers.class);
        private final EnumMap<ParCoolConfig.Client.Doubles, Double> doubles = new EnumMap(ParCoolConfig.Client.Doubles.class);

        public Remote() {
            Arrays.fill(this.actionPossibilities, true);
            Arrays.fill(this.staminaConsumptions, 0);
            for (ParCoolConfig.Client.Booleans booleans : ParCoolConfig.Client.Booleans.values()) {
                this.booleans.put(booleans, booleans.DefaultValue);
            }
            for (Enum enum_ : ParCoolConfig.Client.Integers.values()) {
                this.integers.put((ParCoolConfig.Client.Integers)enum_, ((ParCoolConfig.Client.Integers)enum_).DefaultValue);
            }
            for (Enum enum_ : ParCoolConfig.Client.Doubles.values()) {
                this.doubles.put((ParCoolConfig.Client.Doubles)enum_, ((ParCoolConfig.Client.Doubles)enum_).DefaultValue);
            }
        }

        @Override
        public boolean getPossibilityOf(Class<? extends Action> action) {
            return this.actionPossibilities[ActionList.getIndexOf(action)];
        }

        @Override
        public int getStaminaConsumptionOf(Class<? extends Action> action) {
            return this.staminaConsumptions[ActionList.getIndexOf(action)];
        }

        @Override
        public Boolean get(ParCoolConfig.Client.Booleans item) {
            return this.booleans.get(item);
        }

        @Override
        public Integer get(ParCoolConfig.Client.Integers item) {
            return this.integers.get(item);
        }

        @Override
        public Double get(ParCoolConfig.Client.Doubles item) {
            return this.doubles.get(item);
        }
    }

    private static class Default
    extends ClientSetting {
        private Default() {
        }

        @Override
        public boolean getPossibilityOf(Class<? extends Action> action) {
            return false;
        }

        @Override
        public int getStaminaConsumptionOf(Class<? extends Action> action) {
            return Integer.MAX_VALUE;
        }

        @Override
        public Boolean get(ParCoolConfig.Client.Booleans item) {
            return item.DefaultValue;
        }

        @Override
        public Integer get(ParCoolConfig.Client.Integers item) {
            return item.DefaultValue;
        }

        @Override
        public Double get(ParCoolConfig.Client.Doubles item) {
            return item.DefaultValue;
        }
    }
}

