/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.stamina;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class HungerStamina
implements IStamina {
    private final Player player;
    private float consumedBuffer = 0.0f;

    public HungerStamina(Player player) {
        this.player = player;
    }

    @Override
    public int getActualMaxStamina() {
        return 20;
    }

    @Override
    public int get() {
        return this.player.m_36324_().m_38702_();
    }

    @Override
    public int getOldValue() {
        return this.get();
    }

    @Override
    public void consume(int value) {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.isExhausted() || parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        this.consumedBuffer += (float)value / 150.0f;
    }

    @Override
    public void recover(int value) {
    }

    @Override
    public boolean isExhausted() {
        return this.get() <= 6;
    }

    @Override
    public void setExhaustion(boolean value) {
    }

    @Override
    public void tick() {
    }

    @Override
    public void set(int value) {
    }

    @Override
    public boolean wantToConsumeOnServer() {
        return this.consumedBuffer != 0.0f;
    }

    @Override
    public int getRequestedValueConsumedOnServer() {
        int neededValue = (int)(this.consumedBuffer * 10000.0f);
        this.consumedBuffer = 0.0f;
        return neededValue;
    }

    public static void consumeOnServer(ServerPlayer player, int value) {
        player.m_36399_((float)value / 10000.0f);
    }
}

