/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.world.entity.player.Player;

public class PlayerModelRotator {
    private final PoseStack stack;
    private final Player player;
    private final float partial;
    private double playerHeight = 1.8;
    private final float givenXRot;
    private final float givenYRot;
    private final float givenZRot;
    private boolean basedCenter = false;
    private boolean basedTop = false;

    public float getXRot() {
        return this.givenXRot;
    }

    public float getYRot() {
        return this.givenYRot;
    }

    public float getZRot() {
        return this.givenZRot;
    }

    public float getPartialTick() {
        return this.partial;
    }

    public PlayerModelRotator(PoseStack stack, Player player, float partial, float xRot, float yRot, float zRot) {
        this.stack = stack;
        this.player = player;
        this.partial = partial;
        this.givenXRot = xRot;
        this.givenYRot = yRot;
        this.givenZRot = zRot;
        switch (player.m_20089_()) {
            case SWIMMING: 
            case CROUCHING: 
            case SLEEPING: {
                this.playerHeight = 0.6;
            }
        }
    }

    public PlayerModelRotator start() {
        return this;
    }

    public PlayerModelRotator startBasedCenter() {
        this.basedCenter = true;
        this.stack.m_85837_(0.0, this.playerHeight / 2.0, 0.0);
        return this;
    }

    public PlayerModelRotator startBasedTop() {
        this.basedTop = true;
        this.stack.m_85837_(0.0, this.playerHeight, 0.0);
        return this;
    }

    public PoseStack getRawStack() {
        return this.stack;
    }

    public PlayerModelRotator translateY(float offset) {
        this.stack.m_85837_(0.0, (double)offset, 0.0);
        return this;
    }

    public PlayerModelRotator translate(float offsetX, float offsetY, float offsetZ) {
        this.stack.m_85837_((double)offsetX, (double)offsetY, (double)offsetZ);
        return this;
    }

    public PlayerModelRotator rotatePitchFrontward(float angleDegree) {
        this.stack.m_85845_(Vector3f.f_122222_.m_122240_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateRollRightward(float angleDegree) {
        this.stack.m_85845_(Vector3f.f_122226_.m_122240_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateYawRightward(float angleDegree) {
        this.stack.m_85845_(Vector3f.f_122224_.m_122240_(angleDegree));
        return this;
    }

    public void end() {
        if (this.basedCenter) {
            this.stack.m_85837_(0.0, -this.playerHeight / 2.0, 0.0);
        }
        if (this.basedTop) {
            this.stack.m_85837_(0.0, -this.playerHeight, 0.0);
        }
    }

    public void endEnabledLegGrounding() {
        this.end();
    }
}

