/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.option;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.SpruceTexts;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.SpruceButtonWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;

public class SpruceBooleanOption
extends SpruceOption {
    private final Supplier<Boolean> getter;
    private final Consumer<Boolean> setter;
    private final boolean colored;

    public SpruceBooleanOption(String key, Supplier<Boolean> getter, Consumer<Boolean> setter, @Nullable Component tooltip) {
        this(key, getter, setter, tooltip, false);
    }

    public SpruceBooleanOption(String key, Supplier<Boolean> getter, Consumer<Boolean> setter, @Nullable Component tooltip, boolean colored) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.colored = colored;
        this.setTooltip(tooltip);
    }

    public void set(String value) {
        this.set("true".equals(value));
    }

    public void set() {
        this.set(!this.get());
    }

    private void set(boolean value) {
        this.setter.accept(value);
    }

    public boolean get() {
        return this.getter.get();
    }

    public boolean isColored() {
        return this.colored;
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceButtonWidget button = new SpruceButtonWidget(position, width, 20, this.getDisplayText(), btn -> {
            this.set();
            btn.setMessage(this.getDisplayText());
        });
        this.getOptionTooltip().ifPresent(button::setTooltip);
        return button;
    }

    public Component getDisplayText() {
        boolean value = this.get();
        Component toggleText = SpruceTexts.getToggleText(value);
        if (this.colored) {
            toggleText = toggleText.m_6881_().m_6270_(toggleText.m_7383_().m_131140_(value ? ChatFormatting.GREEN : ChatFormatting.RED));
        }
        return this.getDisplayText(toggleText);
    }
}

