/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.letmefeedyou;

import com.rinko1231.letmefeedyou.Config.FeedPlayerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="letmefeedyou")
public class LetMeFeedYou {
    public static final String MODID = "letmefeedyou";
    private static final long FEED_COOLDOWN = 1000L;
    private static final HashMap<UUID, Long> playerFeedCooldowns = new HashMap();

    public LetMeFeedYou() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FeedPlayerConfig.setup();
    }

    @SubscribeEvent
    public void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            if (!event.getLevel().f_46443_) {
                long lastFedTime;
                Player feeder = event.getEntity();
                ItemStack foodItem = feeder.m_21205_();
                if (!foodItem.m_41614_()) {
                    return;
                }
                String itemId = ForgeRegistries.ITEMS.getKey((Object)foodItem.m_41720_()).toString();
                if (((List)FeedPlayerConfig.foodBlacklist.get()).contains(itemId)) {
                    return;
                }
                if (targetPlayer.m_36324_().m_38702_() >= (Integer)FeedPlayerConfig.canBeFedBelowHungerOf.get()) {
                    return;
                }
                UUID targetUUID = targetPlayer.m_20148_();
                long currentTime = System.currentTimeMillis();
                playerFeedCooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 1000L);
                if (playerFeedCooldowns.containsKey(targetUUID) && currentTime - (lastFedTime = playerFeedCooldowns.get(targetUUID).longValue()) < 1000L) {
                    return;
                }
                Component foodName = foodItem.m_41788_() ? foodItem.m_41786_() : foodItem.m_41611_();
                String feederName = feeder.m_5446_().getString();
                ItemStack consumed = foodItem.m_41671_(targetPlayer.m_9236_(), (LivingEntity)targetPlayer);
                targetPlayer.m_5661_((Component)Component.m_237110_((String)"info.letmefeedyou.success", (Object[])new Object[]{feederName, foodName}), true);
                if (!feeder.m_150110_().f_35937_) {
                    feeder.m_21008_(InteractionHand.MAIN_HAND, consumed);
                }
                playerFeedCooldowns.put(targetUUID, currentTime);
            }
        }
    }
}

