/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;

public class CustomBossBar {
    public static Map<Integer, CustomBossBar> customBossBars = new HashMap<Integer, CustomBossBar>();
    private final ResourceLocation baseTexture;
    private final ResourceLocation overlayTexture;
    private final boolean hasOverlay;
    private final int baseHeight;
    private final int baseTextureHeight;
    private final int baseOffsetX;
    private final int baseOffsetY;
    private final int overlayOffsetX;
    private final int overlayOffsetY;
    private final int overlayWidth;
    private final int overlayHeight;
    private final int verticalIncrement;
    private final int getProgress;
    private final ChatFormatting textColor;

    public CustomBossBar(ResourceLocation baseTexture, ResourceLocation overlayTexture, int baseHeight, int baseTextureHeight, int baseOffsetX, int baseOffsetY, int overlayOffsetX, int overlayOffsetY, int overlayWidth, int overlayHeight, int verticalIncrement, int getProgress, ChatFormatting textColor) {
        this.baseTexture = baseTexture;
        this.overlayTexture = overlayTexture;
        this.hasOverlay = overlayTexture != null;
        this.baseHeight = baseHeight;
        this.baseTextureHeight = baseTextureHeight;
        this.baseOffsetX = baseOffsetX;
        this.baseOffsetY = baseOffsetY;
        this.overlayOffsetX = overlayOffsetX;
        this.overlayOffsetY = overlayOffsetY;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.verticalIncrement = verticalIncrement;
        this.getProgress = getProgress;
        this.textColor = textColor;
    }

    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public int getBaseTextureHeight() {
        return this.baseTextureHeight;
    }

    public int getBaseOffsetX() {
        return this.baseOffsetX;
    }

    public int getBaseOffsetY() {
        return this.baseOffsetY;
    }

    public int getOverlayOffsetX() {
        return this.overlayOffsetX;
    }

    public int getOverlayOffsetY() {
        return this.overlayOffsetY;
    }

    public int getOverlayWidth() {
        return this.overlayWidth;
    }

    public int getOverlayHeight() {
        return this.overlayHeight;
    }

    public int getProgress() {
        return this.getProgress;
    }

    public int getVerticalIncrement() {
        return this.verticalIncrement;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        PoseStack stack = event.getPoseStack();
        int y = event.getY();
        int i = Minecraft.m_91087_().m_91268_().m_85445_();
        int j = y - 9;
        Minecraft.m_91087_().m_91307_().m_6180_("CataclysmCustomBossBarBase");
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBaseTexture());
        this.drawBar(stack, event.getX() + this.getBaseOffsetX(), y + this.getBaseOffsetY(), (BossEvent)event.getBossEvent());
        MutableComponent component = event.getBossEvent().m_18861_().m_6881_().m_130940_(this.getTextColor());
        Minecraft.m_91087_().m_91307_().m_7238_();
        int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        int i1 = i / 2 - l / 2;
        int j1 = j;
        Minecraft.m_91087_().f_91062_.m_92877_(stack, component.m_7532_(), (float)i1, (float)j1, 0xFFFFFF);
        if (this.hasOverlay()) {
            Minecraft.m_91087_().m_91307_().m_6180_("CataclysmCustomBossBarOverlay");
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getOverlayTexture());
            GuiComponent.m_93133_((PoseStack)stack, (int)(event.getX() + this.getBaseOffsetX() + this.getOverlayOffsetX()), (int)(y + this.getOverlayOffsetY() + this.getBaseOffsetY()), (float)0.0f, (float)0.0f, (int)this.getOverlayWidth(), (int)this.getOverlayHeight(), (int)this.getOverlayWidth(), (int)this.getOverlayHeight());
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        event.setIncrement(this.getVerticalIncrement());
    }

    private void drawBar(PoseStack stack, int x, int y, BossEvent event) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBaseTexture());
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getProgress(), (int)this.getBaseHeight(), (int)256, (int)this.getBaseTextureHeight());
        int i = (int)(event.m_142717_() * (float)(this.getProgress() + 1));
        if (i > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBaseTexture());
            GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)this.getBaseHeight(), (int)i, (int)this.getBaseHeight(), (int)256, (int)this.getBaseTextureHeight());
        }
    }

    static {
        customBossBars.put(0, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/monstrosity_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/monstrosity_bar_overlay.png"), 5, 16, 1, 1, -2, -2, 256, 16, 25, 182, ChatFormatting.RED));
        customBossBars.put(1, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/ender_guardian_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/ender_guardian_bar_overlay.png"), 5, 16, 1, 1, -2, -2, 256, 16, 25, 182, ChatFormatting.LIGHT_PURPLE));
        customBossBars.put(2, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/ignis_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/ignis_bar_overlay.png"), 5, 16, 1, 1, -2, -2, 256, 16, 25, 182, ChatFormatting.YELLOW));
        customBossBars.put(3, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/ignis_soul_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/ignis_soul_bar_overlay.png"), 5, 16, 1, 1, -2, -2, 256, 16, 25, 182, ChatFormatting.DARK_AQUA));
        customBossBars.put(4, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/harbinger_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/harbinger_bar_overlay.png"), 5, 16, 1, 7, -2, -8, 256, 32, 25, 182, ChatFormatting.DARK_RED));
        customBossBars.put(5, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/leviathan_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/leviathan_bar_overlay.png"), 5, 16, 1, 2, -4, -4, 256, 16, 25, 182, ChatFormatting.DARK_PURPLE));
        customBossBars.put(6, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/leviathan_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/leviathan_meltdown_bar_overlay.png"), 5, 16, 1, 4, -4, -6, 256, 16, 25, 182, ChatFormatting.DARK_PURPLE));
        customBossBars.put(7, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/remnant_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/remnant_bar_overlay.png"), 5, 16, 1, 7, -4, -10, 256, 32, 30, 182, ChatFormatting.WHITE));
        customBossBars.put(8, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/remnant_rage_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/remnant_rage_bar_overlay.png"), 5, 16, 69, -8, -6, -8, 256, 16, 15, 48, ChatFormatting.DARK_PURPLE));
        customBossBars.put(9, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/maledictus_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/maledictus_bar_overlay.png"), 5, 16, 1, 7, -6, -9, 256, 32, 25, 182, ChatFormatting.DARK_GREEN));
        customBossBars.put(10, new CustomBossBar(new ResourceLocation("cataclysm", "textures/gui/boss_bar/maledictus_rage_bar_base.png"), new ResourceLocation("cataclysm", "textures/gui/boss_bar/maledictus_rage_bar_overlay.png"), 5, 16, 69, -3, -6, -8, 256, 16, 15, 48, ChatFormatting.DARK_PURPLE));
    }
}

