/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.MultiItemValue;

public class FullBlockIngredient
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient example;

    protected FullBlockIngredient(Stream<? extends Ingredient.Value> itemLists, Ingredient example) {
        super(itemLists);
        this.example = example;
    }

    public static boolean isFullBlock(ItemStack stack) {
        if (!FullBlockIngredient.isTextureBlock(stack)) {
            return false;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        BlockState state = block.m_49966_();
        try {
            if (Block.m_49916_((VoxelShape)state.m_60768_(null, BlockPos.f_121853_))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTextureBlock(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        BlockState state = block.m_49966_();
        return state.m_60767_().m_76333_() && state.m_60799_() == RenderShape.MODEL;
    }

    public boolean test(ItemStack stack) {
        return FullBlockIngredient.isFullBlock(stack);
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public static class Serializer
    implements IIngredientSerializer<FullBlockIngredient> {
        public FullBlockIngredient parse(FriendlyByteBuf buffer) {
            Ingredient example = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            MultiItemValue stackList = new MultiItemValue((Collection)ImmutableList.copyOf((Object[])example.m_43908_()));
            return new FullBlockIngredient(Stream.of(stackList), example);
        }

        public FullBlockIngredient parse(JsonObject json) {
            Ingredient example;
            try {
                example = CraftingHelper.getIngredient((JsonElement)json.get("example"));
            }
            catch (JsonSyntaxException e) {
                example = Ingredient.f_43901_;
            }
            MultiItemValue stackList = new MultiItemValue((Collection)ImmutableList.copyOf((Object[])example.m_43908_()));
            return new FullBlockIngredient(Stream.of(stackList), example);
        }

        public void write(FriendlyByteBuf buffer, FullBlockIngredient ingredient) {
            ingredient.example.m_43923_(buffer);
        }
    }
}

