/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;

public class ArmorElement
extends Element {
    private final float armor;

    public ArmorElement(float armor) {
        this.armor = armor;
    }

    @Override
    public Vec2 getSize() {
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            Font font = Minecraft.m_91087_().f_91062_;
            return new Vec2((float)(8 + font.m_92895_(text)), 10.0f);
        }
        int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int lineCount = (int)Math.ceil(this.armor / (float)maxHearts * 0.5f);
        return new Vec2((float)(8 * maxHearts), (float)(10 * lineCount));
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            DisplayHelper.renderIcon(matrixStack, x, y, 8, 8, IconUI.ARMOR);
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            DisplayHelper.INSTANCE.drawText(matrixStack, text, x + 8.0f, y, OverlayRenderer.normalTextColorRaw);
        } else {
            float armor = this.armor * 0.5f;
            int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            int lineCount = (int)Math.ceil(armor / (float)maxHearts);
            int armorCount = lineCount * maxHearts;
            int xOffset = 0;
            for (int i = 1; i <= armorCount; ++i) {
                if (i <= Mth.m_14143_((float)armor)) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.ARMOR);
                    xOffset += 8;
                }
                if ((float)i > armor && (float)i < armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                    xOffset += 8;
                }
                if ((float)i >= armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                    xOffset += 8;
                }
                if (i % maxHearts != 0) continue;
                y += 10.0f;
                xOffset = 0;
            }
        }
    }

    @Override
    @Nullable
    public Component getMessage() {
        return Component.m_237110_((String)"narration.jade.armor", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.armor)});
    }
}

