/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ViewGroup<T> {
    public final List<T> views;
    @Nullable
    public String id;
    @Nullable
    protected CompoundTag extraData;

    public ViewGroup(List<T> views) {
        this.views = views;
    }

    public void save(CompoundTag tag, Function<T, CompoundTag> writer) {
        ListTag list = new ListTag();
        for (T view : this.views) {
            list.add((Object)((Tag)writer.apply(view)));
        }
        tag.m_128365_("Views", (Tag)list);
        if (this.id != null) {
            tag.m_128359_("Id", this.id);
        }
        if (this.extraData != null) {
            tag.m_128365_("Data", (Tag)this.extraData);
        }
    }

    public static <T> ViewGroup<T> read(CompoundTag tag, Function<CompoundTag, T> reader) {
        ListTag list = tag.m_128437_("Views", 10);
        ArrayList views = Lists.newArrayList();
        for (Tag view : list) {
            views.add(reader.apply((CompoundTag)view));
        }
        ViewGroup<T> group = new ViewGroup<T>(views);
        if (tag.m_128441_("Id")) {
            group.id = tag.m_128461_("Id");
        }
        if (tag.m_128441_("Data")) {
            group.extraData = tag.m_128469_("Data");
        }
        return group;
    }

    public static <T> boolean saveList(CompoundTag tag, String key, List<ViewGroup<T>> groups, Function<T, CompoundTag> writer) {
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        ListTag groupList = new ListTag();
        for (int i = 0; i < groups.size(); ++i) {
            ViewGroup<T> group = groups.get(i);
            if (group.views.isEmpty()) continue;
            CompoundTag groupTag = new CompoundTag();
            group.save(groupTag, writer);
            groupList.add((Object)groupTag);
        }
        if (!groupList.isEmpty()) {
            tag.m_128365_(key, (Tag)groupList);
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> List<ViewGroup<T>> readList(CompoundTag tag, String key, Function<CompoundTag, T> reader) {
        ListTag list = tag.m_128437_(key, 10);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList groups = Lists.newArrayList();
        for (Tag item : list) {
            ViewGroup<T> group = ViewGroup.read((CompoundTag)item, reader);
            if (group.views.isEmpty()) continue;
            groups.add(group);
        }
        return groups;
    }

    public CompoundTag getExtraData() {
        if (this.extraData == null) {
            this.extraData = new CompoundTag();
        }
        return this.extraData;
    }

    public void setProgress(float progress) {
        this.getExtraData().m_128350_("Progress", progress);
    }
}

