/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelState;

public class TransformUtils {
    private static final Transformation flipX = new Transformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final PerspectiveModelState IDENTITY = PerspectiveModelState.IDENTITY;
    public static final PerspectiveModelState DEFAULT_BLOCK;
    public static final PerspectiveModelState DEFAULT_ITEM;
    public static final PerspectiveModelState DEFAULT_TOOL;
    public static final PerspectiveModelState DEFAULT_BOW;
    public static final PerspectiveModelState DEFAULT_HANDHELD_ROD;

    public static Transformation create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TransformUtils.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static Transformation create(Vector3 transform, Vector3 rotation, Vector3 scale) {
        return TransformUtils.create(transform.vector3f(), rotation.vector3f(), scale.vector3f());
    }

    public static Transformation create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return new Transformation(transform, new Quaternion(rotation.m_122239_(), rotation.m_122260_(), rotation.m_122269_(), true), scale, null);
    }

    public static Transformation create(ItemTransform transform) {
        if (ItemTransform.f_111754_.equals((Object)transform)) {
            return Transformation.m_121093_();
        }
        return TransformUtils.create(transform.f_111756_, transform.f_111755_, transform.f_111757_);
    }

    public static Transformation flipLeft(Transformation transform) {
        return flipX.m_121096_(transform).m_121096_(flipX);
    }

    public static ModelState stateFromItemTransforms(ItemTransforms itemTransforms) {
        if (itemTransforms == ItemTransforms.f_111786_) {
            return IDENTITY;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ItemTransforms.TransformType value : ItemTransforms.TransformType.values()) {
            map.put((Object)value, (Object)TransformUtils.create(itemTransforms.m_111808_(value)));
        }
        return new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)map.build());
    }

    public static void applyLeftyFlip(PoseStack pStack) {
        if (!pStack.m_85851_()) {
            Matrix4f tMat = pStack.m_85850_().m_85861_();
            Matrix3f nMat = pStack.m_85850_().m_85864_();
            tMat.multiplyBackward(flipX.m_121104_());
            tMat.m_27644_(flipX.m_121104_());
            nMat.multiplyBackward(flipX.getNormalMatrix());
            nMat.m_8178_(flipX.getNormalMatrix());
            pStack.m_85850_().m_85861_().m_27644_(tMat);
            pStack.m_85850_().m_85864_().m_8178_(nMat);
        }
    }

    static {
        HashMap<ItemTransforms.TransformType, Transformation> map = new HashMap<ItemTransforms.TransformType, Transformation>();
        Transformation thirdPerson = TransformUtils.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        map.put(ItemTransforms.TransformType.GUI, TransformUtils.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        map.put(ItemTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        map.put(ItemTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        thirdPerson = TransformUtils.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        Transformation firstPerson = TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        map.put(ItemTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemTransforms.TransformType.HEAD, TransformUtils.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPerson);
        map.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.flipLeft(firstPerson));
        DEFAULT_ITEM = new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        map.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        map.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = new PerspectiveModelState((Map<ItemTransforms.TransformType, Transformation>)ImmutableMap.copyOf(map));
    }
}

