/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.covers1624.quack.image.AnimatedGifEncoder;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ItemFileRenderer {
    public static final int DEFAULT_RES = 512;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LinkedList<RenderTask> tasks = new LinkedList();
    private static final List<GifRenderTask> gifTasks = new LinkedList<GifRenderTask>();

    public static void addRenderTask(ItemStack stack, Path file, int resolution) {
        tasks.add(new RenderTask(stack, file, resolution));
    }

    public static void addGifRenderTask(ItemStack stack, Path file, int resolution, int fps, int duration) {
        gifTasks.add(new GifRenderTask(stack, file, resolution, fps, duration));
    }

    public static void tick() {
        ItemFileRenderer.renderStackToFile();
        ItemFileRenderer.renderGifs();
    }

    private static void renderStackToFile() {
        if (tasks.isEmpty()) {
            return;
        }
        RenderTask task = tasks.pop();
        ItemFileRenderer.takeItemScreenshot(task.stack, task.resolution, image -> {
            try {
                image.m_85066_(IOUtils.makeParents(task.file));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write image to file.", (Throwable)ex);
            }
        });
    }

    private static void renderGifs() {
        gifTasks.removeIf(GifRenderTask::render);
    }

    private static void takeItemScreenshot(ItemStack stack, int res, Consumer<NativeImage> cons) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget mainTarget = mc.m_91385_();
        PoseStack pStack = RenderSystem.m_157191_();
        if (mainTarget.f_83915_ < res || mainTarget.f_83916_ < res) {
            LOGGER.warn("Window is not at least 512x512 make it bigger! Your image is probably cropped a bit.");
        }
        Matrix4f ortho = Matrix4f.m_162203_((float)0.0f, (float)((float)mainTarget.f_83915_ * 16.0f / (float)res), (float)0.0f, (float)((float)mainTarget.f_83916_ * 16.0f / (float)res), (float)-3000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)ortho);
        pStack.m_85836_();
        pStack.m_166856_();
        RenderSystem.m_157182_();
        mainTarget.m_83947_(true);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glClear((int)16640);
        Lighting.m_84931_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        mc.m_91291_().m_115123_(stack, 0, 0);
        try (NativeImage fullScreenshot = new NativeImage(mainTarget.f_83915_, mainTarget.f_83916_, false);
             NativeImage subImage = new NativeImage(res, res, false);){
            RenderSystem.m_69396_((int)mainTarget.m_83975_());
            fullScreenshot.m_85045_(0, false);
            fullScreenshot.m_85122_();
            fullScreenshot.m_85034_(0, 0, res, res, subImage);
            cons.accept(subImage);
        }
        pStack.m_85849_();
        RenderSystem.m_157182_();
        mainTarget.m_83970_();
    }

    private record RenderTask(ItemStack stack, Path file, int resolution) {
    }

    private static final class GifRenderTask {
        public final ItemStack stack;
        public final Path file;
        private final int resolution;
        public final int fps;
        public final long targetDuration;
        public final List<byte[]> frames;
        public final long frameDelay;
        public long startTime = -1L;
        public long lastFrame;

        private GifRenderTask(ItemStack stack, Path file, int resolution, int fps, int targetDuration) {
            this.stack = stack;
            this.file = file;
            this.resolution = resolution;
            this.fps = fps;
            this.targetDuration = TimeUnit.SECONDS.toMillis(targetDuration);
            this.frames = new ArrayList<byte[]>(targetDuration * fps);
            this.frameDelay = (long)(1.0f / (float)fps * 1000.0f);
        }

        public boolean render() {
            long currTime = System.currentTimeMillis();
            if (this.startTime == -1L) {
                this.startTime = currTime;
            }
            if (this.startTime + this.targetDuration <= currTime) {
                CompletableFuture.runAsync(this::finishGif);
                return true;
            }
            if (this.lastFrame + this.frameDelay > currTime) {
                return false;
            }
            this.lastFrame = currTime;
            ItemFileRenderer.takeItemScreenshot(this.stack, this.resolution, SneakyUtils.sneak(e -> this.frames.add(e.m_85121_())));
            LOGGER.info("Captured gif frame {} / {}", (Object)this.frames.size(), (Object)(this.targetDuration / 1000L * (long)this.fps));
            return false;
        }

        private void finishGif() {
            LOGGER.info("Writing gif..");
            try (OutputStream os = Files.newOutputStream(this.file, new OpenOption[0]);){
                AnimatedGifEncoder encoder = new AnimatedGifEncoder();
                encoder.start(os);
                encoder.setDelay((int)this.frameDelay);
                encoder.setRepeat(0);
                encoder.setQuality(1);
                for (int i = 0; i < this.frames.size(); ++i) {
                    byte[] frame = this.frames.get(i);
                    LOGGER.info("Encoding Frame {} / {}", (Object)(i + 1), (Object)this.frames.size());
                    encoder.addFrame(ImageIO.read(new ByteArrayInputStream(frame)));
                }
                encoder.finish();
                LOGGER.info("Finished writing gif.");
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write gif.", (Throwable)ex);
            }
        }
    }
}

