/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.data.event.GatherDataEvent;

public abstract class LanguageProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> client = new TreeMap<String, String>();
    private final Map<String, String> server = new TreeMap<String, String>();
    private final DataGenerator gen;
    private final String modid;
    private final String locale;
    private final Side distFilter;

    protected LanguageProvider(DataGenerator gen, String modid, String locale, Side distFilter) {
        this.gen = gen;
        this.modid = modid;
        this.locale = locale;
        this.distFilter = distFilter;
    }

    protected abstract void addTranslations();

    public void m_213708_(CachedOutput p_200398_1_) throws IOException {
        this.addTranslations();
        if (this.distFilter.includeClient() && !this.client.isEmpty()) {
            this.save(p_200398_1_, this.client, this.gen.m_123916_().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
        if (this.distFilter.includeServer() && !this.server.isEmpty()) {
            this.save(p_200398_1_, this.server, this.gen.m_123916_().resolve("data/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String m_6055_() {
        return this.modid + " Languages: " + this.locale;
    }

    public String getLocale() {
        return this.locale;
    }

    private void save(CachedOutput cache, Object object, Path target) throws IOException {
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)GSON.toJsonTree(object), (Path)target);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get().m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get().m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get().m_41778_(), name);
    }

    public void addEnchantment(Supplier<Enchantment> key, String name) {
        this.add(key.get().m_44704_(), name);
    }

    public void addEffect(Supplier<MobEffect> key, String name) {
        this.add(key.get().m_19481_(), name);
    }

    public void addEntityType(Supplier<EntityType<?>> key, String name) {
        this.add(key.get().m_20675_(), name);
    }

    public void add(String key, String name) {
        if (this.client.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public void addServer(String key, String name) {
        this.add(key, name);
        if (this.server.put(key, name) != null) {
            throw new IllegalArgumentException("Duplicate translation key :" + key);
        }
    }

    public static Side getDist(GatherDataEvent event) {
        if (event.includeServer() && event.includeClient()) {
            return Side.BOTH;
        }
        if (event.includeServer()) {
            return Side.SERVER;
        }
        if (event.includeClient()) {
            return Side.CLIENT;
        }
        return Side.NONE;
    }

    public static enum Side {
        CLIENT,
        SERVER,
        BOTH,
        NONE;


        public boolean includeClient() {
            return this == CLIENT || this == BOTH;
        }

        public boolean includeServer() {
            return this == SERVER || this == BOTH;
        }
    }
}

