/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigSyncManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, ConfigTag> SYNC_MAP = new HashMap<ResourceLocation, ConfigTag>();

    public static void registerSync(ResourceLocation key, ConfigTag tag) {
        ConfigTag prev = SYNC_MAP.put(key, tag);
        if (prev != null) {
            throw new IllegalArgumentException("Key '" + key + "' already registered.");
        }
    }

    public static void handleLogin(BiConsumer<String, Supplier<PacketCustom>> consumer) {
        if (SYNC_MAP.isEmpty()) {
            return;
        }
        consumer.accept("config_sync", () -> {
            PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1);
            packet.writeVarInt(SYNC_MAP.size());
            for (Map.Entry<ResourceLocation, ConfigTag> entry : SYNC_MAP.entrySet()) {
                packet.writeResourceLocation(entry.getKey());
                entry.getValue().write(packet);
            }
            String mods = Joiner.on((String)", ").join(SYNC_MAP.keySet());
            LOGGER.info("Sending config sync packet for {} to connecting player.", (Object)mods);
            return packet;
        });
    }

    public static void readSyncPacket(PacketCustom packet) {
        int numPackets = packet.readVarInt();
        for (int i = 0; i < numPackets; ++i) {
            ResourceLocation ident = packet.readResourceLocation();
            LOGGER.info("Applying config sync for {}.", (Object)ident);
            ConfigTag config = SYNC_MAP.get(ident);
            if (config == null) {
                LOGGER.fatal("Client is missing sync tag: {}. Potentially skipped other configs!", (Object)ident);
                return;
            }
            config.read(packet);
            config.runSync(ConfigCallback.Reason.SYNC);
        }
    }

    public static void onClientDisconnected() {
        for (Map.Entry<ResourceLocation, ConfigTag> entry : SYNC_MAP.entrySet()) {
            LOGGER.info("Client disconnected, rolling back config for {}.", (Object)entry.getKey());
            ConfigTag config = entry.getValue();
            config.resetFromNetwork();
            config.runSync(ConfigCallback.Reason.ROLLBACK);
        }
    }
}

