/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.crafting.GunSmithTableResult;
import com.tacz.guns.resource.CommonGunPackLoader;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public class GunSmithTableResultSerializer
implements JsonDeserializer<GunSmithTableResult> {
    public GunSmithTableResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            GunSmithTableResult result;
            JsonObject jsonObject = json.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"id"));
            String typeName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type");
            int count = 1;
            if (jsonObject.has("count")) {
                count = Math.max(GsonHelper.m_13927_((JsonObject)jsonObject, (String)"count"), 1);
            }
            switch (typeName) {
                case "gun": {
                    result = this.getGunStack(id, count, jsonObject);
                    break;
                }
                case "ammo": {
                    result = this.getAmmoStack(id, count);
                    break;
                }
                case "attachment": {
                    result = this.getAttachmentStack(id, count);
                    break;
                }
                default: {
                    return new GunSmithTableResult(ItemStack.f_41583_, "");
                }
            }
            if (jsonObject.has("nbt")) {
                CompoundTag extraTag = CraftingHelper.getNBT((JsonElement)jsonObject.get("nbt"));
                CompoundTag itemTag = result.getResult().m_41784_();
                for (String key : extraTag.m_128431_()) {
                    Tag tag = extraTag.m_128423_(key);
                    if (tag == null) continue;
                    itemTag.m_128365_(key, tag);
                }
            }
            return result;
        }
        return new GunSmithTableResult(ItemStack.f_41583_, "");
    }

    private GunSmithTableResult getGunStack(ResourceLocation id, int count, JsonObject extraData) {
        GunResult gunResult = (GunResult)CommonGunPackLoader.GSON.fromJson((JsonElement)extraData, GunResult.class);
        int ammoCount = Math.max(0, gunResult.getAmmoCount());
        EnumMap<AttachmentType, ResourceLocation> attachments = gunResult.getAttachments();
        return TimelessAPI.getCommonGunIndex(id).map(gunIndex -> {
            ItemStack itemStack = GunItemBuilder.create().setCount(count).setId(id).setAmmoCount(ammoCount).setAmmoInBarrel(false).putAllAttachment(attachments).setFireMode(gunIndex.getGunData().getFireModeSet().get(0)).build();
            String group = gunIndex.getType();
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(ItemStack.f_41583_, ""));
    }

    private GunSmithTableResult getAmmoStack(ResourceLocation id, int count) {
        return new GunSmithTableResult(AmmoItemBuilder.create().setCount(count).setId(id).build(), "ammo");
    }

    private GunSmithTableResult getAttachmentStack(ResourceLocation id, int count) {
        return TimelessAPI.getCommonAttachmentIndex(id).map(attachmentIndex -> {
            ItemStack itemStack = AttachmentItemBuilder.create().setCount(count).setId(id).build();
            String group = attachmentIndex.getType().name().toLowerCase(Locale.US);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(ItemStack.f_41583_, ""));
    }
}

