/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.config.util;

import com.google.common.collect.Lists;
import com.tacz.guns.config.sync.SyncConfig;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class InteractKeyConfigRead {
    private static final EnumMap<Type, List<ResourceLocation>> WHITELIST = new EnumMap(Type.class);
    private static final EnumMap<Type, List<ResourceLocation>> BLACKLIST = new EnumMap(Type.class);
    private static final TagKey<Block> WHITELIST_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("tacz", "interact_key/whitelist"));
    private static final TagKey<Block> BLACKLIST_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("tacz", "interact_key/blacklist"));
    private static final TagKey<EntityType<?>> WHITELIST_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tacz", "interact_key/whitelist"));
    private static final TagKey<EntityType<?>> BLACKLIST_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tacz", "interact_key/blacklist"));

    public static void init() {
        WHITELIST.clear();
        BLACKLIST.clear();
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_BLOCKS.get(), WHITELIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_ENTITIES.get(), WHITELIST, Type.ENTITY);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_BLOCKS.get(), BLACKLIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_ENTITIES.get(), BLACKLIST, Type.ENTITY);
    }

    public static boolean canInteractBlock(BlockState block) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block.m_60734_());
        if (blockId == null) {
            return false;
        }
        if (BLACKLIST.containsKey((Object)Type.BLOCK) && BLACKLIST.get((Object)Type.BLOCK).contains(blockId)) {
            return false;
        }
        if (block.m_204336_(BLACKLIST_BLOCKS)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.BLOCK) && WHITELIST.get((Object)Type.BLOCK).contains(blockId)) {
            return true;
        }
        return block.m_204336_(WHITELIST_BLOCKS);
    }

    public static boolean canInteractEntity(Entity entity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        if (BLACKLIST.containsKey((Object)Type.ENTITY) && BLACKLIST.get((Object)Type.ENTITY).contains(entityId)) {
            return false;
        }
        if (entity.m_6095_().m_204039_(BLACKLIST_ENTITIES)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.ENTITY) && WHITELIST.get((Object)Type.ENTITY).contains(entityId)) {
            return true;
        }
        return entity.m_6095_().m_204039_(WHITELIST_ENTITIES);
    }

    private static void handleConfigData(List<String> configData, EnumMap<Type, List<ResourceLocation>> storeList, Type type) {
        configData.forEach(data -> {
            if (data.isEmpty()) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)data)) {
                return;
            }
            ResourceLocation id = new ResourceLocation(data);
            storeList.computeIfAbsent(type, t -> Lists.newArrayList()).add(id);
        });
    }

    public static enum Type {
        BLOCK,
        ENTITY;

    }
}

