/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.input.InteractKey;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.util.InteractKeyConfigRead;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.apache.commons.lang3.StringUtils;

public class InteractKeyTextOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (((Boolean)RenderConfig.DISABLE_INTERACT_HUD_TEXT.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        if (!IGun.mainhandHoldGun((LivingEntity)player)) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            InteractKeyTextOverlay.renderBlockText(graphics, width, height, blockHitResult, player, mc);
            return;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            InteractKeyTextOverlay.renderEntityText(graphics, width, height, entityHitResult, mc);
        }
    }

    private static void renderBlockText(GuiGraphics graphics, int width, int height, BlockHitResult blockHitResult, LocalPlayer player, Minecraft mc) {
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockState block = player.m_9236_().m_8055_(blockPos);
        if (InteractKeyConfigRead.canInteractBlock(block)) {
            InteractKeyTextOverlay.renderText(graphics, width, height, mc.f_91062_);
        }
    }

    private static void renderEntityText(GuiGraphics graphics, int width, int height, EntityHitResult entityHitResult, Minecraft mc) {
        Entity entity = entityHitResult.m_82443_();
        if (InteractKeyConfigRead.canInteractEntity(entity)) {
            InteractKeyTextOverlay.renderText(graphics, width, height, mc.f_91062_);
        }
    }

    private static void renderText(GuiGraphics graphics, int width, int height, Font font) {
        String keyName = InteractKey.INTERACT_KEY.m_90863_().getString();
        MutableComponent title = Component.m_237110_((String)"gui.tacz.interact_key.text.desc", (Object[])new Object[]{StringUtils.capitalize((String)keyName)});
        graphics.m_280614_(font, (Component)title, (int)((float)(width - font.m_92852_((FormattedText)title)) / 2.0f), (int)((float)height / 2.0f - 25.0f), ChatFormatting.YELLOW.m_126665_().intValue(), false);
    }
}

