/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerShoot;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LocalPlayerShoot {
    private static final Predicate<IGunOperator> SHOOT_LOCKED_CONDITION = operator -> operator.getSynShootCoolDown() > 0L;
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerShoot(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public ShootResult shoot() {
        if (System.currentTimeMillis() - LocalPlayerDataHolder.clientClickButtonTimestamp < 50L) {
            return ShootResult.COOL_DOWN;
        }
        if (!this.data.isShootRecorded) {
            return ShootResult.COOL_DOWN;
        }
        if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
            this.data.isShootRecorded = true;
            return ShootResult.IS_DRAWING;
        }
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return ShootResult.NOT_GUN;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return ShootResult.ID_NOT_EXIST;
        }
        ClientGunIndex gunIndex = gunIndexOptional.get();
        GunData gunData = gunIndex.getGunData();
        long coolDown = this.getCoolDown(iGun, mainhandItem, gunData);
        if (coolDown >= 50L) {
            return ShootResult.COOL_DOWN;
        }
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)this.player);
        if (gunOperator.getSynReloadState().getStateType().isReloading()) {
            return ShootResult.IS_RELOADING;
        }
        if (gunOperator.getSynDrawCoolDown() != 0L) {
            return ShootResult.IS_DRAWING;
        }
        if (gunOperator.getSynMeleeCoolDown() != 0L) {
            return ShootResult.IS_MELEE;
        }
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(mainhandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = iGun.getCurrentAmmoCount(mainhandItem) + (hasAmmoInBarrel ? 1 : 0);
        if (ammoCount < 1) {
            SoundPlayManager.playDryFireSound((LivingEntity)this.player, gunIndex);
            return ShootResult.NO_AMMO;
        }
        if (boltType == Bolt.MANUAL_ACTION && !hasAmmoInBarrel) {
            IClientPlayerGunOperator.fromLocalPlayer(this.player).bolt();
            return ShootResult.NEED_BOLT;
        }
        if (gunOperator.getSynSprintTime() > 0.0f) {
            return ShootResult.IS_SPRINTING;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new GunShootEvent((LivingEntity)this.player, mainhandItem, LogicalSide.CLIENT))) {
            return ShootResult.FORGE_EVENT_CANCEL;
        }
        this.data.lockState(SHOOT_LOCKED_CONDITION);
        this.data.isShootRecorded = false;
        this.doShoot(gunIndex, iGun, mainhandItem, gunData, coolDown);
        return ShootResult.SUCCESS;
    }

    private void doShoot(ClientGunIndex gunIndex, IGun iGun, ItemStack mainhandItem, GunData gunData, long delay) {
        boolean hasAmmoInBarrel;
        FireMode fireMode = iGun.getFireMode(mainhandItem);
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean consumeAmmo = IGunOperator.fromLivingEntity((LivingEntity)this.player).consumesAmmoOrNot();
        boolean bl = hasAmmoInBarrel = iGun.hasBulletInBarrel(mainhandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = consumeAmmo ? iGun.getCurrentAmmoCount(mainhandItem) + (hasAmmoInBarrel ? 1 : 0) : Integer.MAX_VALUE;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        int maxCount = Math.min(ammoCount, fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1);
        AtomicInteger count = new AtomicInteger(0);
        LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            boolean fire;
            if (count.get() == 0) {
                this.data.isShootRecorded = true;
            }
            if (count.get() >= maxCount || this.player.m_21224_()) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() == 0) {
                if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
                    return;
                }
                this.data.clientShootTimestamp = System.currentTimeMillis();
                NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerShoot());
            }
            boolean bl = fire = !MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent((LivingEntity)this.player, mainhandItem, LogicalSide.CLIENT));
            if (fire) {
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onGunShoot();
                }
                boolean useSilenceSound = this.useSilenceSound();
                Minecraft.m_91087_().m_18689_(() -> {
                    SoundPlayManager.stopPlayGunSound(gunIndex, SoundManager.INSPECT_SOUND);
                    if (useSilenceSound) {
                        SoundPlayManager.playSilenceSound((LivingEntity)this.player, gunIndex);
                    } else {
                        SoundPlayManager.playShootSound((LivingEntity)this.player, gunIndex);
                    }
                });
            }
            count.getAndIncrement();
        }, delay, period, TimeUnit.MILLISECONDS);
    }

    private boolean useSilenceSound() {
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((LivingEntity)this.player).getCacheProperty();
        if (cacheProperty != null) {
            Pair silence = (Pair)cacheProperty.getCache("silence");
            return (Boolean)silence.right();
        }
        return false;
    }

    private long getCoolDown(IGun iGun, ItemStack mainHandItem, GunData gunData) {
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        long coolDown = fireMode == FireMode.BURST ? (long)(gunData.getBurstData().getMinInterval() * 1000.0) - (System.currentTimeMillis() - this.data.clientShootTimestamp) : gunData.getShootInterval((LivingEntity)this.player, fireMode) - (System.currentTimeMillis() - this.data.clientShootTimestamp);
        return Math.max(coolDown, 0L);
    }

    public long getClientShootCoolDown() {
        ItemStack mainHandItem = this.player.m_21205_();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return -1L;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndexOptional.map(commonGunIndex -> this.getCoolDown(iGun, mainHandItem, commonGunIndex.getGunData())).orElse(-1L);
    }
}

