/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client;

import dev.architectury.event.events.client.ClientTickEvent;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import me.edoren.skin_changer.client.CustomSkinTexture;
import me.edoren.skin_changer.client.api.ISkin;
import me.edoren.skin_changer.client.api.SkinLoaderService;
import me.edoren.skin_changer.common.models.PlayerModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;

public class ClientController {
    private static ClientController singleInstance = null;
    final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();

    private ClientController() {
    }

    public static ClientController GetInstance() {
        if (singleInstance == null) {
            singleInstance = new ClientController();
        }
        return singleInstance;
    }

    public void initialize() {
        ClientTickEvent.CLIENT_PRE.register(this::onClientTickEvent);
    }

    public void deinitialize() {
        ClientTickEvent.CLIENT_PRE.unregister(this::onClientTickEvent);
    }

    public ResourceLocation getLocationCape(PlayerModel model) {
        ISkin cape = SkinLoaderService.GetInstance().getCape(model);
        if (cape != null && cape.isDataReady()) {
            return this.getOrCreateTexture(cape.getData(), cape).getLocation();
        }
        return null;
    }

    public ResourceLocation getLocationSkin(PlayerModel model) {
        ISkin skin = SkinLoaderService.GetInstance().getSkin(model);
        if (skin != null && skin.isDataReady()) {
            return this.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public String getSkinType(PlayerModel model) {
        ISkin skin;
        ResourceLocation location = this.getLocationSkin(model);
        if (location != null && (skin = SkinLoaderService.GetInstance().getSkin(model)) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return null;
    }

    public CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!this.textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(this.generateRandomLocation(), data);
            Minecraft.m_91087_().m_91097_().m_118495_(texture.getLocation(), (AbstractTexture)texture);
            this.textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        Minecraft.m_91087_().execute(() -> {
                            Minecraft.m_91087_().m_91097_().m_118513_(texture.getLocation());
                            this.textures.remove(data);
                        });
                    }
                });
            }
        }
        return this.textures.get(data);
    }

    private void onClientTickEvent(Minecraft mc) {
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            for (AbstractClientPlayer player : world.m_6907_()) {
                PlayerModel model = new PlayerModel(player.m_36316_());
                SkinLoaderService.GetInstance().getSkin(model);
                SkinLoaderService.GetInstance().getCape(model);
            }
        }
    }

    private ResourceLocation generateRandomLocation() {
        return new ResourceLocation("skin_changer", String.format("textures/generated/%s", UUID.randomUUID()));
    }
}

