/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.gui.ingredients.IngredientFilter;
import mezz.jei.gui.ingredients.IngredientFilterApi;
import mezz.jei.library.runtime.JeiRuntime;
import net.minecraft.client.searchtree.RefreshableSearchTree;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.searchtree.DummySearchTree;
import org.embeddedt.modernfix.searchtree.JEIRuntimeCapturer;
import org.embeddedt.modernfix.searchtree.SearchTreeProviderRegistry;

public class JEIBackedSearchTree
extends DummySearchTree<ItemStack> {
    private final boolean filteringByTag;
    private String lastSearchText = "";
    private final List<ItemStack> listCache = new ArrayList<ItemStack>();
    private static final Field filterField;
    private static final MethodHandle getIngredientListUncached;
    public static final SearchTreeProviderRegistry.Provider PROVIDER;

    public JEIBackedSearchTree(boolean filteringByTag) {
        this.filteringByTag = filteringByTag;
    }

    @Override
    public List<ItemStack> m_6293_(String pSearchText) {
        Optional<JeiRuntime> runtime = JEIRuntimeCapturer.runtime();
        if (runtime.isPresent()) {
            IngredientFilter filter;
            IngredientFilterApi iFilterApi = (IngredientFilterApi)runtime.get().getIngredientFilter();
            try {
                filter = (IngredientFilter)filterField.get(iFilterApi);
            }
            catch (ReflectiveOperationException e) {
                ModernFix.LOGGER.error((Object)e);
                return Collections.emptyList();
            }
            return this.searchJEI(filter, pSearchText);
        }
        return super.m_6293_(pSearchText);
    }

    private List<ItemStack> searchJEI(IngredientFilter filter, String pSearchText) {
        if (!pSearchText.equals(this.lastSearchText)) {
            Stream ingredients;
            this.listCache.clear();
            Object finalSearchTerm = this.filteringByTag ? "$" + pSearchText : pSearchText;
            try {
                ingredients = getIngredientListUncached.invokeExact(filter, (String)finalSearchTerm);
            }
            catch (Throwable e) {
                ModernFix.LOGGER.error("Error searching", e);
                ingredients = Stream.empty();
            }
            ingredients.toList().forEach(ingredient -> {
                if (ingredient.getIngredient() instanceof ItemStack) {
                    this.listCache.add((ItemStack)ingredient.getIngredient());
                }
            });
            this.lastSearchText = pSearchText;
        }
        return this.listCache;
    }

    static {
        Field f;
        MethodHandle m;
        try {
            Method jeiMethod = IngredientFilter.class.getDeclaredMethod("getIngredientListUncached", String.class);
            jeiMethod.setAccessible(true);
            m = MethodHandles.lookup().unreflect(jeiMethod);
            f = IngredientFilterApi.class.getDeclaredField("ingredientFilter");
            f.setAccessible(true);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException | RuntimeException e) {
            m = null;
            f = null;
        }
        getIngredientListUncached = m;
        filterField = f;
        PROVIDER = new SearchTreeProviderRegistry.Provider(){

            @Override
            public RefreshableSearchTree<ItemStack> getSearchTree(boolean tag) {
                return new JEIBackedSearchTree(tag);
            }

            @Override
            public boolean canUse() {
                return ModernFixPlatformHooks.INSTANCE.modPresent("jei") && !ModernFixPlatformHooks.INSTANCE.modPresent("emi") && getIngredientListUncached != null && filterField != null;
            }

            @Override
            public String getName() {
                return "JEI";
            }
        };
    }
}

