/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.oldcreatestuff;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.teammoeg.steampowered.oldcreatestuff.InterpolatedChasingValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class OldFlywheelBlockEntity
extends GeneratingKineticBlockEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    public InterpolatedChasingValue visualSpeed = new InterpolatedChasingValue();
    public float angle;

    public OldFlywheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        return OldFlywheelBlockEntity.convertToDirection((float)this.generatedSpeed, (Direction)((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)));
    }

    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.generatedCapacity;
        return this.lastCapacityProvided;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("GeneratedSpeed", this.generatedSpeed);
        compound.m_128350_("GeneratedCapacity", this.generatedCapacity);
        compound.m_128405_("Cooldown", this.stoppingCooldown);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        this.generatedCapacity = compound.m_128457_("GeneratedCapacity");
        this.stoppingCooldown = compound.m_128451_("Cooldown");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.withSpeed(0.03125f).target(this.getGeneratedSpeed());
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.target(targetSpeed);
            this.visualSpeed.tick();
            this.angle += this.visualSpeed.value * 3.0f / 10.0f;
            this.angle %= 360.0f;
        } else {
            if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
                this.updateGeneratedRotation();
            }
            if (this.stoppingCooldown != 0) {
                --this.stoppingCooldown;
                if (this.stoppingCooldown == 0) {
                    this.generatedCapacity = 0.0f;
                    this.generatedSpeed = 0.0f;
                    this.updateGeneratedRotation();
                }
            }
        }
    }
}

