/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SchematicBlockPalette {
    public static final UnboundedMapCodec<BlockState, Integer> CODEC = Codec.unboundedMap(Entry.CODEC, (Codec)Codec.INT);

    private static <T extends Comparable<T>> BlockState process(Property<T> property, String value, BlockState state) {
        return (BlockState)state.m_61124_(property, (Comparable)property.m_6215_(value).orElseThrow(NullPointerException::new));
    }

    public static interface Entry {
        public static final Codec<BlockState> CODEC = Codec.STRING.comapFlatMap(Entry::to, Entry::from);

        public static DataResult<BlockState> to(String string) {
            BlockStateParser.BlockResult parser;
            StringReader reader = new StringReader(string);
            try {
                parser = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)reader, (boolean)true);
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
            }
            return DataResult.success((Object)parser.f_234748_());
        }

        public static String from(BlockState state) {
            StringBuilder builder = new StringBuilder();
            builder.append(Objects.requireNonNull(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_())));
            boolean flag = true;
            Iterator iterator = state.m_61147_().iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    builder.append("[");
                    flag = false;
                }
                Property property = (Property)iterator.next();
                builder.append(property.m_61708_());
                builder.append("=");
                if (state.m_61143_(property) instanceof Enum) {
                    builder.append(((StringRepresentable)state.m_61143_(property)).m_7912_());
                } else {
                    builder.append(state.m_61143_(property).toString());
                }
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            if (!flag) {
                builder.append("]");
            }
            return builder.toString();
        }
    }
}

