/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.rift.targets.WrappedDestinationTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PublicPocketTarget
extends WrappedDestinationTarget {
    public static final Codec<PublicPocketTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VirtualTarget.CODEC.optionalFieldOf("wrappedDestination", null).forGetter(a -> a.wrappedDestination)).apply((Applicative)instance, PublicPocketTarget::new));

    private PublicPocketTarget(VirtualTarget wrappedDestination) {
        super(wrappedDestination);
    }

    public PublicPocketTarget() {
    }

    @Override
    public Location makeLinkTarget() {
        VirtualLocation riftVirtualLocation = VirtualLocation.fromLocation(this.location);
        int depth = riftVirtualLocation.getDepth() + 1;
        VirtualLocation newVirtualLocation = new VirtualLocation(riftVirtualLocation.getWorld(), riftVirtualLocation.getX(), riftVirtualLocation.getZ(), depth);
        Pocket pocket = PocketGenerator.generatePublicPocketV2(newVirtualLocation, new GlobalReference(this.location), null);
        return DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket);
    }

    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.PUBLIC_POCKET.get();
    }

    @Override
    public VirtualTarget copy() {
        return new PublicPocketTarget(this.wrappedDestination);
    }
}

