/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftDataModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.TemplateTarget;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class TemplateModifier
extends AbstractModifier {
    public static final String KEY = "template";
    private ResourceLocation templateId;
    private List<Integer> ids;

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        this.templateId = ResourceLocation.m_135820_((String)nbt.m_128461_("templateId"));
        this.ids = RiftDataModifier.stream(nbt.m_128463_("ids")).boxed().collect(Collectors.toList());
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128359_("templateId", this.templateId.toString());
        nbt.m_128382_("ids", RiftDataModifier.toByteArray(this.ids.stream().mapToInt(Integer::intValue).toArray()));
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.TEMPLATE_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        TemplateTarget template = new TemplateTarget(this.templateId);
        manager.foreachConsume((id, rift) -> {
            if (this.ids.contains(id)) {
                rift.setDestination(template.copy());
                return true;
            }
            return false;
        });
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }
}

