/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import dev.architectury.event.CompoundEventResult;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.item.ExtendedItem;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.item.RaycastHelper;
import org.dimdev.dimdoors.item.component.CounterComponent;
import org.dimdev.dimdoors.network.ServerPacketHandler;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.jetbrains.annotations.Nullable;

public class RiftConfigurationToolItem
extends Item
implements ExtendedItem {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String ID = "rift_configuration_tool";

    RiftConfigurationToolItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(16));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hit = RaycastHelper.findDetachRift((Entity)player, RaycastHelper.RIFT);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        CounterComponent counter = CounterComponent.get(stack);
        if (RaycastHelper.hitsRift((HitResult)hit, (BlockGetter)world)) {
            RiftBlockEntity rift = (RiftBlockEntity)world.m_7702_(hit.m_82425_());
            if (rift.getDestination() instanceof IdMarker && ((IdMarker)rift.getDestination()).getId() < counter.count()) {
                EntityUtils.chat((Entity)player, (Component)Component.m_237113_((String)("Id: " + ((IdMarker)rift.getDestination()).getId())));
            } else {
                int id = counter.increment();
                ServerPacketHandler.get((ServerPlayer)player).sync(stack, hand);
                EntityUtils.chat((Entity)player, (Component)Component.m_237113_((String)("Rift stripped of data and set to target id: " + id)));
                rift.setDestination(new IdMarker(id));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        EntityUtils.chat((Entity)player, (Component)Component.m_237113_((String)("Current Count: " + counter.count())));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public CompoundEventResult<Boolean> onAttackBlock(Level world, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        if (world.f_46443_) {
            if (player.m_6144_()) {
                if (CounterComponent.get(player.m_21120_(hand)).count() != 0 || world.m_7702_(pos) instanceof RiftBlockEntity) {
                    return CompoundEventResult.interruptTrue((Object)true);
                }
                return CompoundEventResult.interruptFalse((Object)false);
            }
        } else {
            ItemStack stack = player.m_21120_(hand);
            if (player.m_6144_()) {
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof RiftBlockEntity) {
                    RiftBlockEntity rift = (RiftBlockEntity)blockEntity;
                    if (!(rift.getDestination() instanceof IdMarker) || ((IdMarker)rift.getDestination()).getId() != -1) {
                        rift.setDestination(new IdMarker(-1));
                        EntityUtils.chat((Entity)player, (Component)Component.m_237113_((String)"Rift stripped of data and set to invalid id: -1"));
                        return CompoundEventResult.interruptTrue((Object)false);
                    }
                } else if (CounterComponent.get(stack).count() != 0) {
                    CounterComponent.get(stack).reset();
                    ServerPacketHandler.get((ServerPlayer)player).sync(stack, hand);
                    EntityUtils.chat((Entity)player, (Component)Component.m_237113_((String)"Counter has been reset."));
                    return CompoundEventResult.interruptTrue((Object)false);
                }
            }
        }
        return CompoundEventResult.interruptTrue((Object)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (I18n.m_118936_((String)(this.m_5524_() + ".info"))) {
            list.add((Component)Component.m_237115_((String)(this.m_5524_() + ".info")));
        }
    }
}

