/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.Rotations;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;

public class DimTeleportCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimteleport").requires(source -> source.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            return DimTeleportCommand.teleport((Entity)player, DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), player.m_20182_(), MathUtil.entityEulerAngle((Entity)player));
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"coordinates", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            return DimTeleportCommand.teleport((Entity)player, DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"coordinates"), MathUtil.entityEulerAngle((Entity)player));
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"yaw", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            return DimTeleportCommand.teleport((Entity)player, DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"coordinates"), new Rotations(player.m_146909_(), FloatArgumentType.getFloat((CommandContext)ctx, (String)"yaw"), 0.0f));
        })).then(Commands.m_82129_((String)"pitch", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            return DimTeleportCommand.teleport((Entity)player, DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"coordinates"), new Rotations(FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"yaw"), 0.0f));
        }))))));
    }

    private static int teleport(Entity entity, ServerLevel dimension, Vec3 pos, Rotations angle) {
        if (entity instanceof Player) {
            DimensionalRegistry.getRiftRegistry().setOverworldRift(entity.m_20148_(), new Location((ServerLevel)entity.m_9236_(), entity.m_20183_()));
        }
        TeleportUtil.teleport(entity, (Level)dimension, pos, angle, entity.m_20184_());
        return 1;
    }
}

