/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client.forge;

import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlockRegistrar;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.client.DimensionalDoorsClient;
import org.dimdev.dimdoors.client.ModEntityModelLayers;
import org.dimdev.dimdoors.client.config.ModMenu;
import org.dimdev.dimdoors.client.effect.DungeonDimensionEffect;
import org.dimdev.dimdoors.client.effect.LimboDimensionEffect;

@Mod.EventBusSubscriber(modid="dimdoors", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DimensionalDoorsForgeClient {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> ModMenu.getConfigScreen(screen)));
        DimensionalDoorsClient.init();
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        DimensionalDoorsClient.initParticles((particleType, particleProvider) -> event.registerSpecial(particleType, particleProvider), (particleType, spriteSetFunction) -> event.registerSpriteSet(particleType, spriteSetFunction::apply));
    }

    @SubscribeEvent
    public static void registerEntities(EntityRenderersEvent.RegisterRenderers event) {
        DimensionalDoorsClient.initEntitiesClient((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModEntityModelLayers.initClient((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void modifyBake(ModelEvent.RegisterAdditional event) {
        event.register(DimensionalDoorsClient.childItem);
    }

    @SubscribeEvent
    public static void modifyBake(ModelEvent.ModifyBakingResult event) {
        DimensionalDoorBlockRegistrar blockRegistrar = DimensionalDoors.getDimensionalDoorBlockRegistrar();
        DimensionalDoors.getDimensionalDoorBlockRegistrar().getGennedIds().stream().filter(DimensionalDoors.getDimensionalDoorBlockRegistrar()::isMapped).forEach(identifier -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(identifier);
            if (block == null) {
                return;
            }
            ResourceLocation mapped = blockRegistrar.get((ResourceLocation)identifier);
            Block original = (Block)ForgeRegistries.BLOCKS.getValue(mapped);
            if (original == null) {
                return;
            }
            original.m_49965_().m_61056_().forEach(blockState -> {
                BlockState state = UnravelUtil.copyState(block, blockState);
                BakedModel model = (BakedModel)event.getModelBakery().m_119251_().get(BlockModelShaper.m_110895_((BlockState)blockState));
                event.getModels().put(BlockModelShaper.m_110895_((BlockState)((BlockState)state.m_61124_((Property)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)))), model);
                event.getModels().put(BlockModelShaper.m_110895_((BlockState)state), model);
            });
        });
        BakedModel childItem = (BakedModel)event.getModelBakery().m_119251_().get(DimensionalDoorsClient.childItem);
        ForgeRegistries.ITEMS.getKeys().stream().filter(a -> a.m_135815_().startsWith("item_ag_dim_")).forEach(location -> event.getModels().put(new ModelResourceLocation(location, "inventory"), childItem));
    }

    @SubscribeEvent
    public static void registerDimensionEffect(RegisterDimensionSpecialEffectsEvent event) {
        event.register(DimensionalDoors.id("limbo"), (DimensionSpecialEffects)LimboDimensionEffect.INSTANCE);
        event.register(DimensionalDoors.id("dungeon"), (DimensionSpecialEffects)DungeonDimensionEffect.INSTANCE);
    }
}

