/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.DimensionalDoors;

public class Location {
    public static final Codec<Location> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("world").forGetter(location -> location.world), (App)BlockPos.f_121852_.fieldOf("pos").forGetter(location -> location.pos)).apply((Applicative)instance, Location::new));
    public final ResourceKey<Level> world;
    public final BlockPos pos;

    public Location(ResourceKey<Level> world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public Location(ServerLevel world, int x, int y, int z) {
        this(world, new BlockPos(x, y, z));
    }

    public Location(ServerLevel world, BlockPos pos) {
        this((ResourceKey<Level>)world.m_46472_(), pos);
    }

    public int getX() {
        return this.pos.m_123341_();
    }

    public int getY() {
        return this.pos.m_123342_();
    }

    public int getZ() {
        return this.pos.m_123343_();
    }

    public BlockState getBlockState() {
        return this.getWorld().m_8055_(this.pos);
    }

    public FluidState getFluidState() {
        return this.getWorld().m_6425_(this.pos);
    }

    public BlockEntity getBlockEntity() {
        return this.getWorld().m_7702_(this.pos);
    }

    public Holder<Biome> getBiome() {
        return this.getWorld().m_204166_(this.pos);
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public boolean equals(Object obj) {
        return obj instanceof Location && ((Location)obj).world.equals(this.world) && ((Location)obj).pos.equals((Object)this.pos);
    }

    public int hashCode() {
        return this.world.hashCode() * 31 + this.pos.hashCode();
    }

    public ResourceKey<Level> getWorldId() {
        return this.world;
    }

    public ServerLevel getWorld() {
        return DimensionalDoors.getServer().m_129880_(this.world);
    }

    public static CompoundTag toNbt(Location location) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("world", location.world.m_135782_().toString());
        nbt.m_128385_("pos", new int[]{location.getX(), location.getY(), location.getZ()});
        return nbt;
    }

    public static Location fromNbt(CompoundTag nbt) {
        int[] pos = nbt.m_128465_("pos");
        return new Location((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("world"))), new BlockPos(pos[0], pos[1], pos[2]));
    }
}

