/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.mixins;

import com.drmangotea.tfmg.base.TFMGPipes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.AxisPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FluidPropagator.class})
public class FluidPropagatorMixin {
    @Shadow
    public static CreateAdvancement[] getSharedTriggers() {
        return new CreateAdvancement[]{AllAdvancements.WATER_SUPPLY, AllAdvancements.CROSS_STREAMS, AllAdvancements.HONEY_DRAIN};
    }

    @Overwrite(remap=false)
    public static void propagateChangedPipe(LevelAccessor world, BlockPos pipePos, BlockState pipeState) {
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<Pair> discoveredPumps = new HashSet<Pair>();
        frontier.add(Pair.of((Object)0, (Object)pipePos));
        while (!frontier.isEmpty()) {
            Pair pair2 = (Pair)frontier.remove(0);
            BlockPos currentPos = (BlockPos)pair2.getSecond();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState currentState = currentPos.equals((Object)pipePos) ? pipeState : world.m_8055_(currentPos);
            FluidTransportBehaviour pipe = FluidPropagatorMixin.getPipe((BlockGetter)world, currentPos);
            if (pipe == null) continue;
            pipe.wipePressure();
            for (Direction direction : FluidPropagatorMixin.getPipeConnections(currentState, pipe)) {
                Integer distance;
                FluidTransportBehaviour targetPipe;
                Level l;
                BlockPos target = currentPos.m_121945_(direction);
                if (world instanceof Level && !(l = (Level)world).m_46749_(target)) continue;
                BlockEntity tileEntity = world.m_7702_(target);
                BlockState targetState = world.m_8055_(target);
                if (tileEntity instanceof PumpBlockEntity) {
                    if (!TFMGPipes.STEEL_MECHANICAL_PUMP.has(targetState) && !AllBlocks.MECHANICAL_PUMP.has(targetState) && !TFMGPipes.BRASS_MECHANICAL_PUMP.has(targetState) && !TFMGPipes.CAST_IRON_MECHANICAL_PUMP.has(targetState) && !TFMGPipes.ALUMINUM_MECHANICAL_PUMP.has(targetState) && !TFMGPipes.PLASTIC_MECHANICAL_PUMP.has(targetState) || ((Direction)targetState.m_61143_((Property)PumpBlock.FACING)).m_122434_() != direction.m_122434_()) continue;
                    discoveredPumps.add(Pair.of((Object)((PumpBlockEntity)tileEntity), (Object)direction.m_122424_()));
                    continue;
                }
                if (visited.contains(target) || (targetPipe = FluidPropagatorMixin.getPipe((BlockGetter)world, target)) == null || (distance = (Integer)pair2.getFirst()) >= FluidPropagatorMixin.getPumpRange() && !targetPipe.hasAnyPressure() || !targetPipe.canHaveFlowToward(targetState, direction.m_122424_())) continue;
                frontier.add(Pair.of((Object)(distance + 1), (Object)target));
            }
        }
        discoveredPumps.forEach(pair -> ((PumpBlockEntity)pair.getFirst()).updatePipesOnSide((Direction)pair.getSecond()));
    }

    @Shadow
    public static FluidTransportBehaviour getPipe(BlockGetter reader, BlockPos pos) {
        return (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)reader, (BlockPos)pos, (BehaviourType)FluidTransportBehaviour.TYPE);
    }

    @Shadow
    public static boolean isOpenEnd(BlockGetter reader, BlockPos pos, Direction side) {
        BlockPos connectedPos = pos.m_121945_(side);
        BlockState connectedState = reader.m_8055_(connectedPos);
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)reader, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, side.m_122424_())) {
            return false;
        }
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == side.m_122434_()) {
            return false;
        }
        if (VanillaFluidTargets.shouldPipesConnectTo((BlockState)connectedState)) {
            return true;
        }
        if (BlockHelper.hasBlockSolidSide((BlockState)connectedState, (BlockGetter)reader, (BlockPos)connectedPos, (Direction)side.m_122424_()) && !AllTags.AllBlockTags.FAN_TRANSPARENT.matches(connectedState)) {
            return false;
        }
        if (FluidPropagatorMixin.hasFluidCapability(reader, connectedPos, side.m_122424_())) {
            return false;
        }
        return connectedState.m_247087_() && connectedState.m_60800_(reader, connectedPos) != -1.0f || connectedState.m_61138_((Property)BlockStateProperties.f_61362_);
    }

    @Shadow
    public static List<Direction> getPipeConnections(BlockState state, FluidTransportBehaviour pipe) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Iterate.directions) {
            if (!pipe.canHaveFlowToward(state, d)) continue;
            list.add(d);
        }
        return list;
    }

    @Shadow
    public static int getPumpRange() {
        return (Integer)AllConfigs.server().fluids.mechanicalPumpRange.get();
    }

    @Shadow
    public static boolean hasFluidCapability(BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity == null) {
            return false;
        }
        LazyOptional capability = tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, side);
        return capability.isPresent();
    }

    @Shadow
    @Nullable
    public static Direction.Axis getStraightPipeAxis(BlockState state) {
        if (state.m_60734_() instanceof PumpBlock) {
            return ((Direction)state.m_61143_((Property)PumpBlock.FACING)).m_122434_();
        }
        if (state.m_60734_() instanceof AxisPipeBlock) {
            return (Direction.Axis)state.m_61143_((Property)AxisPipeBlock.f_55923_);
        }
        if (!FluidPipeBlock.isPipe((BlockState)state)) {
            return null;
        }
        Direction.Axis axisFound = null;
        int connections = 0;
        for (Direction.Axis axis : Iterate.axes) {
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
            Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            boolean openAt1 = FluidPipeBlock.isOpenAt((BlockState)state, (Direction)d1);
            boolean openAt2 = FluidPipeBlock.isOpenAt((BlockState)state, (Direction)d2);
            if (openAt1) {
                ++connections;
            }
            if (openAt2) {
                ++connections;
            }
            if (!openAt1 || !openAt2) continue;
            if (axisFound != null) {
                return null;
            }
            axisFound = axis;
        }
        return connections == 2 ? axisFound : null;
    }
}

