/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base.cables;

import com.drmangotea.tfmg.blocks.electricity.base.cables.ElectricNetworkManager;
import com.drmangotea.tfmg.blocks.electricity.base.cables.IElectric;
import com.drmangotea.tfmg.blocks.electricity.fuse_block.FuseBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.fuse_block.FusePacket;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class ElectricalNetwork {
    public List<IElectric> members = new ArrayList<IElectric>();
    public long id;
    public int voltage = 0;

    public ElectricalNetwork(long id) {
        this.id = id;
    }

    public void updateNetworkVoltage() {
        int maxVoltage = 0;
        for (IElectric member : this.members) {
            if (member.destroyed()) continue;
            maxVoltage = Math.max(member.voltageGeneration(), maxVoltage);
        }
        this.voltage = maxVoltage;
        this.updateVoltageFromNetwork();
    }

    public void updateVoltageFromNetwork() {
        for (IElectric member : this.members) {
            member.needsVoltageUpdate();
        }
    }

    public void add(IElectric be) {
        ArrayList posList = new ArrayList();
        this.members.forEach(member -> posList.add(member.getId()));
        if (posList.contains(be.getId())) {
            return;
        }
        this.members.add(be);
    }

    public boolean blowFuse() {
        for (IElectric member : this.members) {
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity;
                if (!member.hasElectricitySlot(direction) || !((blockEntity = this.members.get(0).getLevel().m_7702_(BlockPos.m_122022_((long)member.getId()).m_121945_(direction))) instanceof FuseBlockEntity)) continue;
                FuseBlockEntity be = (FuseBlockEntity)blockEntity;
                be.blowFuse();
                if (!member.getLevel().m_5776_()) {
                    TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new FusePacket(be.m_58899_()));
                }
                return true;
            }
        }
        return false;
    }

    public void requestEnergy(SmartBlockEntity blockEntity) {
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            for (IElectric member : this.members) {
                if (member.getForgeEnergy() == null || member.equals(be) || this.voltage == 0 || !member.outputAllowed() || member.getForgeEnergy().getEnergyStored() <= 0) continue;
                ElectricalNetwork.sendEnergy(member, be);
            }
        }
    }

    public void transferEnergy(SmartBlockEntity blockEntity) {
        if (blockEntity instanceof IElectric) {
            IElectric be = (IElectric)blockEntity;
            if (!be.outputAllowed()) {
                return;
            }
            for (IElectric member : this.members) {
                if (member.getForgeEnergy() == null || member.equals(be) || member.voltageGeneration() != 0) continue;
                ElectricalNetwork.sendEnergy(be, member);
                if (be.getForgeEnergy().getEnergyStored() != 0) continue;
                return;
            }
        }
    }

    public static int sendEnergy(IElectric sender, IElectric reciever) {
        int maxTransfer1 = sender.getForgeEnergy().extractEnergy(sender.getForgeEnergy().getEnergyStored(), true);
        int maxTransfer2 = reciever.getForgeEnergy().receiveEnergy(sender.getForgeEnergy().getEnergyStored(), true);
        sender.getForgeEnergy().extractEnergy(Math.min(maxTransfer1, maxTransfer2), false);
        return reciever.getForgeEnergy().receiveEnergy(Math.min(maxTransfer1, maxTransfer2), false);
    }

    public void remove(IElectric be) {
        if (!this.members.contains(be)) {
            return;
        }
        this.members.remove(be);
        if (this.members.isEmpty()) {
            ElectricNetworkManager.networks.get(be.getLevel()).remove(this.id);
            return;
        }
    }
}

