/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.SPTags;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.boiler.BoilerTileEntity;
import com.teammoeg.steampowered.content.engine.SteamEngineBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldEngineBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldEngineBlockEntity;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlockEntity;
import com.teammoeg.steampowered.registrate.SPFluids;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class SteamEngineTileEntity
extends OldEngineBlockEntity
implements IHaveGoggleInformation {
    private FluidTank tank;
    private IFluidHandler handler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int itank) {
            return SteamEngineTileEntity.this.tank.getFluid();
        }

        public int getTankCapacity(int itank) {
            return SteamEngineTileEntity.this.tank.getCapacity();
        }

        public boolean isFluidValid(int itank, FluidStack stack) {
            return SteamEngineTileEntity.this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = SteamEngineTileEntity.this.tank.fill(resource, action);
            if (filled > 0 && action == IFluidHandler.FluidAction.EXECUTE) {
                SteamEngineTileEntity.this.m_6596_();
                SteamEngineTileEntity.this.f_58857_.m_7260_(SteamEngineTileEntity.this.f_58858_, SteamEngineTileEntity.this.m_58900_(), SteamEngineTileEntity.this.m_58900_(), 3);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.handler);
    private int heatup = 0;
    private int paticleInterval;

    public SteamEngineTileEntity(BlockEntityType<? extends SteamEngineTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
        this.tank = new FluidTank(this.getSteamStorage(), fluidStack -> {
            if (SPTags.STEAM != null) {
                return fluidStack.getFluid().m_205067_(SPTags.STEAM);
            }
            return fluidStack.getFluid() == SPFluids.STEAM.get();
        });
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (this.poweredWheel == null) {
                this.attachWheel();
            }
            if (this.poweredWheel == null || this.poweredWheel.m_58901_()) {
                if (this.appliedSpeed != 0.0f || this.appliedCapacity != 0.0f) {
                    this.appliedCapacity = 0.0f;
                    this.appliedSpeed = 0.0f;
                    this.refreshWheelSpeed();
                }
                this.heatup = 0;
                if (!this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                    this.m_6596_();
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                if (((Boolean)state.m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                BlockEntity te;
                Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)OldEngineBlock.f_54117_);
                BlockPos boilerPos = this.f_58858_.m_5484_(engineFacing, -1);
                FluidTank tank = this.tank;
                if (this.tank.isEmpty() && (te = this.m_58904_().m_7702_(boilerPos)) instanceof BoilerTileEntity) {
                    tank = ((BoilerTileEntity)te).output;
                }
                if (this.heatup == 0 && tank.getFluidAmount() / this.getSteamConsumptionPerTick() < 40) {
                    return;
                }
                if (!tank.isEmpty() && tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).getAmount() >= this.getSteamConsumptionPerTick()) {
                    if (this.heatup >= 60) {
                        float spd = this.getGeneratingSpeed();
                        float cap = this.getGeneratingCapacity();
                        if (this.tank != tank) {
                            cap = Mth.m_14165_((double)((double)cap * this.getSuckEfficiency()));
                        }
                        if (this.appliedSpeed != spd || this.appliedCapacity != cap) {
                            this.appliedSpeed = spd;
                            this.appliedCapacity = cap;
                            this.refreshWheelSpeed();
                        }
                    } else {
                        ++this.heatup;
                        this.m_6596_();
                        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                        if (!((Boolean)state.m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
                            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
                        }
                    }
                } else {
                    if (this.heatup > 0) {
                        --this.heatup;
                        this.m_6596_();
                        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                    }
                    if (this.appliedSpeed != 0.0f || this.appliedCapacity != 0.0f) {
                        this.appliedCapacity = 0.0f;
                        this.appliedSpeed = 0.0f;
                        this.refreshWheelSpeed();
                    }
                    if (((Boolean)state.m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
        } else if (((Boolean)this.m_58900_().m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
            ++this.paticleInterval;
            double d0 = (double)this.f_58858_.m_123341_() + 0.5;
            double d1 = this.f_58858_.m_123342_();
            double d2 = (double)this.f_58858_.m_123343_() + 0.5;
            if (this.paticleInterval >= 40) {
                this.paticleInterval = 0;
                this.f_58857_.m_7785_(d0, d1, d2, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.25f, 0.25f, false);
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)SteamEngineBlock.f_54117_);
                Direction.Axis direction$axis = direction.m_122434_();
                double d4 = this.f_58857_.f_46441_.m_188500_() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
                double d6 = this.f_58857_.f_46441_.m_188500_() * 9.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
                this.f_58857_.m_7106_((ParticleOptions)Particles.STEAM.get(), d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        } else {
            this.paticleInterval = 0;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!((Boolean)this.m_58900_().m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Component.m_237115_((String)"tooltip.steampowered.steam_engine.not_enough_steam").m_130940_(ChatFormatting.RED)));
        } else if (this.heatup < 60) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Component.m_237115_((String)"tooltip.steampowered.steam_engine.heating").m_130940_(ChatFormatting.YELLOW)));
        } else {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Component.m_237115_((String)"tooltip.steampowered.steam_engine.running").m_130940_(ChatFormatting.GREEN)));
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.readFromNBT(compound.m_128469_("TankContent"));
        this.heatup = compound.m_128451_("heatup");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
        compound.m_128405_("heatup", this.heatup);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.holder.cast() : super.getCapability(capability, facing);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.handler);
        oldCap.invalidate();
    }

    @Override
    public void attachWheel() {
        BlockEntity te;
        Direction wheelFacing;
        Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)OldEngineBlock.f_54117_);
        BlockPos wheelPos = this.f_58858_.m_5484_(engineFacing, 2);
        BlockState wheelState = this.f_58857_.m_8055_(wheelPos);
        if (!(this.getFlywheel() != wheelState.m_60734_() || (wheelFacing = (Direction)wheelState.m_61143_(OldFlywheelBlock.HORIZONTAL_FACING)).m_122434_() != engineFacing.m_122427_().m_122434_() || OldFlywheelBlock.isConnected(wheelState) && OldFlywheelBlock.getConnection(wheelState) != engineFacing.m_122424_() || (te = this.f_58857_.m_7702_(wheelPos)).m_58901_() || !(te instanceof OldFlywheelBlockEntity))) {
            if (!OldFlywheelBlock.isConnected(wheelState)) {
                OldFlywheelBlock.setConnection(this.f_58857_, te.m_58899_(), te.m_58900_(), engineFacing.m_122424_());
            }
            this.poweredWheel = (OldFlywheelBlockEntity)te;
            this.refreshWheelSpeed();
            return;
        }
        if (this.poweredWheel != null && !this.poweredWheel.m_58901_()) {
            this.poweredWheel.setRotation(0.0f, 0.0f);
            this.poweredWheel = null;
        }
    }

    public abstract Block getFlywheel();

    public abstract float getGeneratingCapacity();

    public abstract float getGeneratingSpeed();

    public abstract int getSteamConsumptionPerTick();

    public abstract int getSteamStorage();

    public abstract double getSuckEfficiency();

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.attachWheel();
    }
}

