/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.util.Utils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.entity.player.Player;

public enum DevCapeUtils {
    INSTANCE;

    public static final Map<UUID, Boolean> usageStatusServerside;
    public static final Map<UUID, Boolean> usageStatusClientside;
    private final Set<UUID> registeredDevs = new HashSet<UUID>();
    private static final String url = "https://raw.githubusercontent.com/Layers-of-Railways/data/main/dev_capes.json";
    private boolean initialized = false;

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.refresh();
    }

    public void refresh() {
        CompletableFuture.runAsync(() -> {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(url)).GET().build();
            try {
                String body = client.send(request, HttpResponse.BodyHandlers.ofString()).body();
                JsonArray devArray = JsonParser.parseString((String)body).getAsJsonObject().getAsJsonArray("dev");
                HashSet<UUID> fetched = new HashSet<UUID>();
                for (JsonElement element : devArray) {
                    JsonObject object;
                    if (!(element instanceof JsonObject) || !(object = (JsonObject)element).has("id")) continue;
                    fetched.add(UUID.fromString(object.get("id").getAsString()));
                }
                this.registeredDevs.clear();
                this.registeredDevs.addAll(fetched);
            }
            catch (Exception e) {
                Railways.LOGGER.error("Failed to fetch dev cape data", (Throwable)e);
            }
        });
    }

    public boolean isDev(Player player) {
        return this.isDev(player.m_20148_());
    }

    public boolean isDev(UUID id) {
        return this.registeredDevs.contains(id) || Utils.isDevEnv();
    }

    public boolean useDevCape(UUID id) {
        return this.isDev(id) && usageStatusClientside.getOrDefault(id, true) != false;
    }

    static {
        usageStatusServerside = new HashMap<UUID, Boolean>();
        usageStatusClientside = new HashMap<UUID, Boolean>();
    }
}

