/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DeployerInstance
extends ShaftInstance<DeployerBlockEntity>
implements DynamicInstance,
TickableInstance {
    final Direction facing;
    final float yRot;
    final float xRot;
    final float zRot;
    protected final OrientedData pole;
    protected OrientedData hand;
    PartialModel currentHand;
    float progress;

    public DeployerInstance(MaterialManager materialManager, DeployerBlockEntity blockEntity) {
        super(materialManager, blockEntity);
        this.facing = (Direction)this.blockState.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)this.blockState.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.m_122434_() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = (OrientedData)this.getOrientedMaterial().getModel(AllPartialModels.DEPLOYER_POLE, this.blockState).createInstance();
        this.currentHand = ((DeployerBlockEntity)this.blockEntity).getHandPose();
        this.hand = (OrientedData)this.getOrientedMaterial().getModel(this.currentHand, this.blockState).createInstance();
        this.progress = this.getProgress(AnimationTickHolder.getPartialTicks());
        DeployerInstance.updateRotation(this.pole, this.hand, this.yRot, this.xRot, this.zRot);
        this.updatePosition();
    }

    public void tick() {
        PartialModel handPose = ((DeployerBlockEntity)this.blockEntity).getHandPose();
        if (this.currentHand != handPose) {
            this.currentHand = handPose;
            this.getOrientedMaterial().getModel(this.currentHand, this.blockState).stealInstance((InstanceData)this.hand);
        }
    }

    public void beginFrame() {
        float newProgress = this.getProgress(AnimationTickHolder.getPartialTicks());
        if (Mth.m_14033_((float)newProgress, (float)this.progress)) {
            return;
        }
        this.progress = newProgress;
        this.updatePosition();
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.hand, this.pole});
    }

    @Override
    public void remove() {
        super.remove();
        this.hand.delete();
        this.pole.delete();
    }

    private float getProgress(float partialTicks) {
        if (((DeployerBlockEntity)this.blockEntity).state == DeployerBlockEntity.State.EXPANDING) {
            float f = 1.0f - ((float)((DeployerBlockEntity)this.blockEntity).timer - partialTicks * (float)((DeployerBlockEntity)this.blockEntity).getTimerSpeed()) / 1000.0f;
            if (((DeployerBlockEntity)this.blockEntity).fistBump) {
                f *= f;
            }
            return f;
        }
        if (((DeployerBlockEntity)this.blockEntity).state == DeployerBlockEntity.State.RETRACTING) {
            return ((float)((DeployerBlockEntity)this.blockEntity).timer - partialTicks * (float)((DeployerBlockEntity)this.blockEntity).getTimerSpeed()) / 1000.0f;
        }
        return 0.0f;
    }

    private void updatePosition() {
        float handLength = this.currentHand == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (this.currentHand == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(Mth.m_14036_((float)this.progress, (float)0.0f, (float)1.0f) * (((DeployerBlockEntity)this.blockEntity).reach + handLength), 1.3125f);
        Vec3i facingVec = this.facing.m_122436_();
        BlockPos blockPos = this.getInstancePosition();
        float x = (float)blockPos.m_123341_() + (float)facingVec.m_123341_() * distance;
        float y = (float)blockPos.m_123342_() + (float)facingVec.m_123342_() * distance;
        float z = (float)blockPos.m_123343_() + (float)facingVec.m_123343_() * distance;
        this.pole.setPosition(x, y, z);
        this.hand.setPosition(x, y, z);
    }

    static void updateRotation(OrientedData pole, OrientedData hand, float yRot, float xRot, float zRot) {
        Quaternionf q = Axis.f_252436_.m_252977_(yRot);
        q.mul((Quaternionfc)Axis.f_252529_.m_252977_(xRot));
        hand.setRotation(q);
        q.mul((Quaternionfc)Axis.f_252403_.m_252977_(zRot));
        pole.setRotation(q);
    }
}

