/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmorItem;
import de.teamlapen.vampirism.util.ArmorMaterial;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterCoatItem
extends VampirismHunterArmorItem
implements IItemWithTier {
    public static final ArmorMaterial.Tiered NORMAL = new ArmorMaterial.Tiered("vampirism:hunter_coat", IItemWithTier.TIER.NORMAL, 17, ArmorMaterial.createReduction(2, 6, 5, 2), 10, SoundEvents.f_11677_, 2.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON));
    public static final ArmorMaterial.Tiered ENHANCED = new ArmorMaterial.Tiered("vampirism:hunter_coat_enhanced", IItemWithTier.TIER.ENHANCED, 25, ArmorMaterial.createReduction(3, 8, 6, 3), 10, SoundEvents.f_11677_, 2.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON));
    public static final ArmorMaterial.Tiered ULTIMATE = new ArmorMaterial.Tiered("vampirism:hunter_coat_ultimate", IItemWithTier.TIER.ULTIMATE, 33, ArmorMaterial.createReduction(3, 9, 9, 3), 10, SoundEvents.f_11677_, 2.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND));
    @NotNull
    private final IItemWithTier.TIER tier;

    @Nullable
    public static IItemWithTier.TIER isFullyEquipped(@NotNull Player player) {
        int minLevel = 1000;
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof HunterCoatItem)) {
                return null;
            }
            minLevel = Math.min(minLevel, ((HunterCoatItem)stack.m_41720_()).getVampirismTier().ordinal());
        }
        return IItemWithTier.TIER.values()[minLevel];
    }

    public HunterCoatItem(@NotNull ArmorItem.Type type, @NotNull ArmorMaterial.Tiered material) {
        super(material, type, new Item.Properties(), new HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>>());
        this.tier = material.getTier();
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

