/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DarkBloodProjectileAction
extends DefaultVampireAction {
    @Override
    public int getCooldown(@NotNull IVampirePlayer player) {
        int cooldown = (Integer)VampirismConfig.BALANCE.vaDarkBloodProjectileCooldown.get() * 20;
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_AOE.get())) {
            cooldown = (int)((double)cooldown * (Double)VampirismConfig.BALANCE.vrDarkBloodProjectileAOECooldownMod.get());
        }
        return cooldown;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaDarkBloodProjectileEnabled.get();
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }

    @Override
    protected boolean activate(@NotNull IVampirePlayer player, IAction.ActivationContext context) {
        Player shooter = player.getRepresentingPlayer();
        float directDamage = ((Double)VampirismConfig.BALANCE.vaDarkBloodProjectileDamage.get()).floatValue();
        float indirectDamage = directDamage * 0.5f;
        float speed = 0.95f;
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_DAMAGE.get())) {
            float modifier = ((Double)VampirismConfig.BALANCE.vrDarkBloodProjectileDamageMod.get()).floatValue();
            directDamage *= modifier;
            indirectDamage *= modifier;
        }
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_SPEED.get())) {
            speed = 1.4f;
        }
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_AOE.get())) {
            for (int i = 0; i < 32; ++i) {
                Vec3 vec3d = this.getRotationVector(shooter.m_5686_(1.0f), shooter.m_5675_(1.0f) + (float)i * 11.25f);
                DarkBloodProjectileEntity entity = this.createProjectile(shooter, shooter.m_20182_(), 0.0, vec3d, false, 0.0f, 0.0f, 0.95f);
                entity.setMaxTicks(7);
                entity.excludeShooter();
                if (i != 0) continue;
                entity.setDamage(0.0f, directDamage);
                entity.explode((Integer)VampirismConfig.BALANCE.vrDarkBloodProjectileAOERange.get(), null);
            }
        } else {
            boolean goThrough = player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_PENETRATION.get());
            this.createProjectile(shooter, shooter.m_20182_(), shooter.m_20192_() * 0.9f, shooter.m_20252_(1.0f), goThrough, directDamage, indirectDamage, speed);
            if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.DARK_BLOOD_PROJECTILE_MULTI_SHOT.get())) {
                this.createProjectile(shooter, shooter.m_20182_(), shooter.m_20192_() * 0.9f, this.getVectorForRotation(shooter.m_5686_(1.0f), shooter.m_5675_(1.0f) + 30.0f), goThrough, directDamage, indirectDamage, speed);
                this.createProjectile(shooter, shooter.m_20182_(), shooter.m_20192_() * 0.9f, this.getVectorForRotation(shooter.m_5686_(1.0f), shooter.m_5675_(1.0f) - 30.0f), goThrough, directDamage, indirectDamage, speed);
            }
        }
        return true;
    }

    @NotNull
    private DarkBloodProjectileEntity createProjectile(@NotNull Player shooter, @NotNull Vec3 position, double height, @NotNull Vec3 direction, boolean goThrough, float directDamage, float indirectDamage, float speed) {
        DarkBloodProjectileEntity entity = new DarkBloodProjectileEntity(shooter.m_20193_(), position.f_82479_ + direction.f_82479_, position.f_82480_ + height, position.f_82481_ + direction.f_82481_, direction.f_82479_, direction.f_82480_, direction.f_82481_);
        entity.setMotionFactor(speed);
        entity.m_5602_((Entity)shooter);
        entity.setDamage(directDamage, indirectDamage);
        if (goThrough) {
            entity.setGothrough(true);
        }
        shooter.m_20193_().m_7967_((Entity)entity);
        return entity;
    }

    @NotNull
    private Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        return new Vec3((double)(f3 * f4), 0.0, (double)(f2 * f4));
    }

    @NotNull
    private Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

